/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Stitcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Comparator<Holder> f_118161_ = Comparator.comparing(p_118201_ -> -p_118201_.f_118204_).thenComparing(p_118199_ -> -p_118199_.f_118203_).thenComparing(p_118197_ -> p_118197_.f_118202_.m_118431_());
    private final int f_118162_;
    private final Set<Holder> f_118163_ = Sets.newHashSetWithExpectedSize((int)256);
    private final List<Region> f_118164_ = Lists.newArrayListWithCapacity((int)256);
    private int f_118165_;
    private int f_118166_;
    private final int f_118167_;
    private final int f_118168_;

    public Stitcher(int p_118171_, int p_118172_, int p_118173_) {
        this.f_118162_ = p_118173_;
        this.f_118167_ = p_118171_;
        this.f_118168_ = p_118172_;
    }

    public int m_118174_() {
        return this.f_118165_;
    }

    public int m_118187_() {
        return this.f_118166_;
    }

    public void m_118185_(TextureAtlasSprite.Info p_118186_) {
        Holder stitcher$holder = new Holder(p_118186_, this.f_118162_);
        this.f_118163_.add(stitcher$holder);
    }

    public void m_118193_() {
        ArrayList list = Lists.newArrayList(this.f_118163_);
        list.sort(f_118161_);
        for (Holder stitcher$holder : list) {
            if (this.m_118178_(stitcher$holder)) continue;
            if (LOGGER.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to fit: ").append(stitcher$holder.f_118202_.m_118431_());
                sb.append(" - size: ").append(stitcher$holder.f_118202_.m_118434_()).append("x").append(stitcher$holder.f_118202_.m_118437_());
                sb.append(" - Maybe try a lower resolution resourcepack?\n");
                list.forEach(h -> sb.append("\t").append(h).append("\n"));
                LOGGER.info(sb.toString());
            }
            throw new StitcherException(stitcher$holder.f_118202_, (Collection)list.stream().map(p_118195_ -> p_118195_.f_118202_).collect(ImmutableList.toImmutableList()));
        }
        this.f_118165_ = Mth.m_14125_((int)this.f_118165_);
        this.f_118166_ = Mth.m_14125_((int)this.f_118166_);
    }

    public void m_118180_(SpriteLoader p_118181_) {
        for (Region stitcher$region : this.f_118164_) {
            stitcher$region.m_118223_(p_118184_ -> {
                Holder stitcher$holder = p_118184_.m_118220_();
                TextureAtlasSprite.Info textureatlassprite$info = stitcher$holder.f_118202_;
                p_118181_.m_118228_(textureatlassprite$info, this.f_118165_, this.f_118166_, p_118184_.m_118225_(), p_118184_.m_118226_());
            });
        }
    }

    static int m_118188_(int p_118189_, int p_118190_) {
        return (p_118189_ >> p_118190_) + ((p_118189_ & (1 << p_118190_) - 1) == 0 ? 0 : 1) << p_118190_;
    }

    private boolean m_118178_(Holder p_118179_) {
        for (Region stitcher$region : this.f_118164_) {
            if (!stitcher$region.m_118221_(p_118179_)) continue;
            return true;
        }
        return this.m_118191_(p_118179_);
    }

    private boolean m_118191_(Holder p_118192_) {
        Region stitcher$region;
        boolean flag;
        boolean flag4;
        boolean flag2;
        int i = Mth.m_14125_((int)this.f_118165_);
        int j = Mth.m_14125_((int)this.f_118166_);
        int k = Mth.m_14125_((int)(this.f_118165_ + p_118192_.f_118203_));
        int l = Mth.m_14125_((int)(this.f_118166_ + p_118192_.f_118204_));
        boolean flag1 = k <= this.f_118167_;
        boolean bl = flag2 = l <= this.f_118168_;
        if (!flag1 && !flag2) {
            return false;
        }
        boolean flag3 = flag1 && i != k;
        boolean bl2 = flag4 = flag2 && j != l;
        if (flag3 ^ flag4) {
            flag = !flag3 && flag1;
        } else {
            boolean bl3 = flag = flag1 && i <= j;
        }
        if (flag) {
            if (this.f_118166_ == 0) {
                this.f_118166_ = p_118192_.f_118204_;
            }
            stitcher$region = new Region(this.f_118165_, 0, p_118192_.f_118203_, this.f_118166_);
            this.f_118165_ += p_118192_.f_118203_;
        } else {
            stitcher$region = new Region(0, this.f_118166_, this.f_118165_, p_118192_.f_118204_);
            this.f_118166_ += p_118192_.f_118204_;
        }
        stitcher$region.m_118221_(p_118192_);
        this.f_118164_.add(stitcher$region);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Holder {
        public final TextureAtlasSprite.Info f_118202_;
        public final int f_118203_;
        public final int f_118204_;

        public Holder(TextureAtlasSprite.Info p_118206_, int p_118207_) {
            this.f_118202_ = p_118206_;
            this.f_118203_ = Stitcher.m_118188_(p_118206_.m_118434_(), p_118207_);
            this.f_118204_ = Stitcher.m_118188_(p_118206_.m_118437_(), p_118207_);
        }

        public String toString() {
            return "Holder{width=" + this.f_118203_ + ", height=" + this.f_118204_ + ", name=" + this.f_118202_.m_118431_() + "}";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Region {
        private final int f_118209_;
        private final int f_118210_;
        private final int f_118211_;
        private final int f_118212_;
        private List<Region> f_118213_;
        private Holder f_118214_;

        public Region(int p_118216_, int p_118217_, int p_118218_, int p_118219_) {
            this.f_118209_ = p_118216_;
            this.f_118210_ = p_118217_;
            this.f_118211_ = p_118218_;
            this.f_118212_ = p_118219_;
        }

        public Holder m_118220_() {
            return this.f_118214_;
        }

        public int m_118225_() {
            return this.f_118209_;
        }

        public int m_118226_() {
            return this.f_118210_;
        }

        public boolean m_118221_(Holder p_118222_) {
            if (this.f_118214_ != null) {
                return false;
            }
            int i = p_118222_.f_118203_;
            int j = p_118222_.f_118204_;
            if (i <= this.f_118211_ && j <= this.f_118212_) {
                if (i == this.f_118211_ && j == this.f_118212_) {
                    this.f_118214_ = p_118222_;
                    return true;
                }
                if (this.f_118213_ == null) {
                    this.f_118213_ = Lists.newArrayListWithCapacity((int)1);
                    this.f_118213_.add(new Region(this.f_118209_, this.f_118210_, i, j));
                    int k = this.f_118211_ - i;
                    int l = this.f_118212_ - j;
                    if (l > 0 && k > 0) {
                        int j1;
                        int i1 = Math.max(this.f_118212_, k);
                        if (i1 >= (j1 = Math.max(this.f_118211_, l))) {
                            this.f_118213_.add(new Region(this.f_118209_, this.f_118210_ + j, i, l));
                            this.f_118213_.add(new Region(this.f_118209_ + i, this.f_118210_, k, this.f_118212_));
                        } else {
                            this.f_118213_.add(new Region(this.f_118209_ + i, this.f_118210_, k, j));
                            this.f_118213_.add(new Region(this.f_118209_, this.f_118210_ + j, this.f_118211_, l));
                        }
                    } else if (k == 0) {
                        this.f_118213_.add(new Region(this.f_118209_, this.f_118210_ + j, i, l));
                    } else if (l == 0) {
                        this.f_118213_.add(new Region(this.f_118209_ + i, this.f_118210_, k, j));
                    }
                }
                for (Region stitcher$region : this.f_118213_) {
                    if (!stitcher$region.m_118221_(p_118222_)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void m_118223_(Consumer<Region> p_118224_) {
            if (this.f_118214_ != null) {
                p_118224_.accept(this);
            } else if (this.f_118213_ != null) {
                for (Region stitcher$region : this.f_118213_) {
                    stitcher$region.m_118223_(p_118224_);
                }
            }
        }

        public String toString() {
            return "Slot{originX=" + this.f_118209_ + ", originY=" + this.f_118210_ + ", width=" + this.f_118211_ + ", height=" + this.f_118212_ + ", texture=" + this.f_118214_ + ", subSlots=" + this.f_118213_ + "}";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface SpriteLoader {
        public void m_118228_(TextureAtlasSprite.Info var1, int var2, int var3, int var4, int var5);
    }
}

