/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.extensions.IForgeTagAppender;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    protected final DataGenerator.PathProvider f_236439_;
    protected final Registry<T> f_126540_;
    protected final Map<ResourceLocation, TagBuilder> f_126543_ = Maps.newLinkedHashMap();
    protected final String modId;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    private final ExistingFileHelper.IResourceType elementResourceType;

    @Deprecated
    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_) {
        this(p_126546_, p_126547_, "vanilla", null);
    }

    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.f_236439_ = p_126546_.m_236036_(DataGenerator.Target.DATA_PACK, TagManager.m_203918_(p_126547_.m_123023_()));
        this.f_126540_ = p_126547_;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", TagManager.m_203918_(p_126547_.m_123023_()));
        this.elementResourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", ForgeHooks.prefixNamespace((ResourceLocation)p_126547_.m_123023_().m_135782_()));
    }

    @Nullable
    protected Path getPath(ResourceLocation id) {
        return this.f_236439_.m_236048_(id);
    }

    public String m_6055_() {
        return "Tags for " + this.f_126540_.m_123023_().m_135782_();
    }

    protected abstract void m_6577_();

    public void m_213708_(CachedOutput p_236446_) {
        this.f_126543_.clear();
        this.m_6577_();
        this.f_126543_.forEach((p_236449_, p_236450_) -> {
            List<TagEntry> list = p_236450_.m_215904_();
            List list1 = list.stream().filter(p_236444_ -> !p_236444_.m_215940_(this.f_126540_::m_7804_, this.f_126543_::containsKey)).filter(this::missing).collect(Collectors.toList());
            if (!list1.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", p_236449_, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonElement jsonelement = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(list, false)).getOrThrow(false, arg_0 -> ((Logger)f_126541_).error(arg_0));
            Path path = this.getPath((ResourceLocation)p_236449_);
            if (path == null) {
                return;
            }
            try {
                DataProvider.m_236072_((CachedOutput)p_236446_, (JsonElement)jsonelement, (Path)path);
            }
            catch (IOException ioexception) {
                f_126541_.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private boolean missing(TagEntry reference) {
        if (reference.isRequired()) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(reference.getId(), reference.isTag() ? this.resourceType : this.elementResourceType);
        }
        return false;
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        TagBuilder tagbuilder = this.m_236451_(p_206425_);
        return new TagAppender<T>(tagbuilder, this.f_126540_, this.modId);
    }

    protected TagBuilder m_236451_(TagKey<T> p_236452_) {
        return this.f_126543_.computeIfAbsent(p_236452_.f_203868_(), p_236442_ -> {
            this.existingFileHelper.trackGenerated(p_236442_, this.resourceType);
            return TagBuilder.m_215899_();
        });
    }

    public static class TagAppender<T>
    implements IForgeTagAppender<T> {
        private final TagBuilder f_126568_;
        public final Registry<T> f_126569_;
        private final String modId;

        TagAppender(TagBuilder p_236454_, Registry<T> p_236455_, String modId) {
            this.f_126568_ = p_236454_;
            this.f_126569_ = p_236455_;
            this.modId = modId;
        }

        public TagAppender<T> m_126582_(T p_126583_) {
            this.f_126568_.m_215900_(this.f_126569_.m_7981_(p_126583_));
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> resourcekey : p_211102_) {
                this.f_126568_.m_215900_(resourcekey.m_135782_());
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_215905_(p_176840_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_215907_(p_206429_.f_203868_());
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_215909_(p_176842_);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_126584_(T ... p_126585_) {
            Stream.of(p_126585_).map(this.f_126569_::m_7981_).forEach(p_126587_ -> this.f_126568_.m_215900_((ResourceLocation)p_126587_));
            return this;
        }

        public TagAppender<T> add(TagEntry tag) {
            this.f_126568_.m_215902_(tag);
            return this;
        }

        public TagBuilder getInternalBuilder() {
            return this.f_126568_;
        }

        public String getModID() {
            return this.modId;
        }
    }
}

