/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.ic2;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ic2.PowerTileEnergySink;
import com.yogpc.qp.machines.PowerTile;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyTile;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Logger;

public final class QuarryIC2Integration {
    private static final Logger LOGGER = QuarryPlus.getLogger(QuarryIC2Integration.class);
    private static final AtomicInteger isIC2Loaded = new AtomicInteger(-1);

    public static boolean isIC2Loaded() {
        int loaded = isIC2Loaded.get();
        if (loaded == -1) {
            boolean ic2 = ModList.get().isLoaded("ic2");
            LOGGER.info("Set QuarryPlus ic2 integration to {}", (Object)ic2);
            isIC2Loaded.set(ic2 ? 1 : 0);
            return ic2;
        }
        return loaded == 1;
    }

    public static void registerIc2Tile(PowerTile tile) {
        if (QuarryIC2Integration.isIC2Loaded()) {
            Internal.register(tile);
        }
    }

    public static void unloadIc2Tile(PowerTile tile) {
        if (QuarryIC2Integration.isIC2Loaded()) {
            Internal.unload(tile);
        }
    }

    private static class Internal {
        private Internal() {
        }

        private static void register(PowerTile tile) {
            PowerTileEnergySink sink = new PowerTileEnergySink(tile);
            EnergyNet.INSTANCE.addTile((IEnergyTile)sink);
            LOGGER.trace("Registered {} as IC2 tile at {} in {}", (Object)((Object)((Object)tile)).getClass().getSimpleName(), (Object)sink.getPosition(), (Object)sink.getWorldObj().m_46472_().m_135782_());
        }

        private static void unload(PowerTile tile) {
            PowerTileEnergySink sink;
            IEnergyTile energyTile = EnergyNet.INSTANCE.getTile(tile.m_58904_(), tile.m_58899_());
            if (energyTile instanceof PowerTileEnergySink && (sink = (PowerTileEnergySink)energyTile).tile() == tile) {
                EnergyNet.INSTANCE.removeTile((IEnergyTile)sink);
                LOGGER.trace("Unregistered {} as IC2 tile at {} in {}", (Object)((Object)((Object)tile)).getClass().getSimpleName(), (Object)sink.getPosition(), (Object)sink.getWorldObj().m_46472_().m_135782_());
            }
        }
    }
}

