/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.DefaultConfig;
import com.yogpc.qp.machines.MachinePowerConfig;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface PowerConfig {
    public static final PowerConfig DEFAULT = new DefaultConfig();

    public static PowerConfig getMachineConfig(String machineName) {
        if (QuarryPlus.config == null) {
            return DEFAULT;
        }
        if (!QuarryPlus.config.powerMap.has(machineName)) {
            return DEFAULT;
        }
        return new MachinePowerConfig(machineName);
    }

    public static Stream<Method> getAllMethods() {
        return Arrays.stream(PowerConfig.class.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> Character.isLowerCase(m.getName().charAt(0))).filter(m -> m.getReturnType() == Long.TYPE || m.getReturnType() == Double.TYPE);
    }

    public long maxEnergy();

    public long makeFrame();

    public long breakBlockBase();

    public long breakBlockFluid();

    public long moveHeadBase();

    public long expCollect();

    public double efficiencyCoefficient();

    public double breakEfficiencyCoefficient();

    public double breakFortuneCoefficient();

    public double breakSilktouchCoefficient();

    public static interface Provider {
        @NotNull
        public PowerConfig getPowerConfig();
    }
}

