/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.advquarry.WorkConfig;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public final class AdvQuarryInitialMessage
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final WorkConfig workConfig;

    public AdvQuarryInitialMessage(BlockPos pos, ResourceKey<Level> dim, WorkConfig workConfig) {
        this.pos = pos;
        this.dim = dim;
        this.workConfig = workConfig;
    }

    public AdvQuarryInitialMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        this.workConfig = new WorkConfig(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos).m_130085_(this.dim.m_135782_());
        this.workConfig.writePacket(buf);
    }

    public static void onReceive(AdvQuarryInitialMessage message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.flatMap(w -> w.m_141902_(message.pos, Holder.ADV_QUARRY_TYPE)).ifPresent(t -> {
            t.workConfig = message.workConfig;
        }));
    }

    public static class Ask
    implements IMessage {
        private final BlockPos pos;
        private final ResourceKey<Level> dim;

        public Ask(BlockPos pos, ResourceKey<Level> dim) {
            this.pos = pos;
            this.dim = dim;
        }

        public Ask(FriendlyByteBuf buf) {
            this.pos = buf.m_130135_();
            this.dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130064_(this.pos).m_130085_(this.dim.m_135782_());
        }

        public static void onReceive(Ask message, Supplier<NetworkEvent.Context> supplier) {
            PacketHandler.getWorld(supplier.get(), message.pos, message.dim).flatMap(w -> w.m_141902_(message.pos, Holder.ADV_QUARRY_TYPE)).ifPresent(t -> PacketHandler.sendToServer(new AdvQuarryInitialMessage(message.pos, message.dim, Ask.getWorkConfig())));
        }

        @NotNull
        private static WorkConfig getWorkConfig() {
            return new WorkConfig((Boolean)QuarryPlus.clientConfig.chunkDestroyerSetting.startImmediately.get(), (Boolean)QuarryPlus.clientConfig.chunkDestroyerSetting.placeAreaFrame.get(), (Boolean)QuarryPlus.clientConfig.chunkDestroyerSetting.chunkByChunk.get());
        }
    }
}

