/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.Tile16Marker;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.MapMulti;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public final class Marker16Message
implements IMessage {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final int amount;
    private final int yMax;
    private final int yMin;

    public Marker16Message(Level world, BlockPos pos, int amount, int yMax, int yMin) {
        this.pos = pos;
        this.dim = world != null ? world.m_46472_() : Level.f_46428_;
        this.amount = amount;
        this.yMax = yMax;
        this.yMin = yMin;
    }

    public Marker16Message(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_());
        this.amount = buffer.m_130242_();
        this.yMax = buffer.m_130242_();
        this.yMin = buffer.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos).m_130085_(this.dim.m_135782_());
        buffer.m_130130_(this.amount);
        buffer.m_130130_(this.yMax);
        buffer.m_130130_(this.yMin);
    }

    public static void onReceive(Marker16Message message, Supplier<NetworkEvent.Context> supplier) {
        Optional<Level> world = PacketHandler.getWorld(supplier.get(), message.pos, message.dim);
        supplier.get().enqueueWork(() -> world.map(w -> w.m_7702_(message.pos)).flatMap(MapMulti.optCast(Tile16Marker.class)).ifPresent(m -> {
            m.changeSize(message.amount, message.yMax, message.yMin);
            PacketHandler.sendToClient(new TileMessage((BlockEntity)m), Objects.requireNonNull(m.m_58904_()));
        }));
    }
}

