/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.placer.PlacerBlock;
import com.yogpc.qp.machines.placer.RemotePlacerTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public final class RemotePlacerBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "remote_placer";

    public RemotePlacerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.2f), NAME);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61360_, (Comparable)Boolean.FALSE));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.REMOTE_PLACER_TYPE.m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!player.m_6047_()) {
            if (!world.f_46443_) {
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() == Items.f_41978_) {
                    world.m_141902_(pos, Holder.REMOTE_PLACER_TYPE).ifPresent(t -> {
                        t.cycleRedstoneMode();
                        player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.placer_rs", (Object[])new Object[]{t.redstoneMode}), false);
                    });
                } else {
                    world.m_141902_(pos, Holder.REMOTE_PLACER_TYPE).ifPresent(o -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)o, (BlockPos)pos));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RemotePlacerTile) {
                RemotePlacerTile placer = (RemotePlacerTile)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)placer);
            }
            super.m_6810_(state, level, pos, newState, moved);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61360_});
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean poweredNow = PlacerBlock.isPoweredToWork(worldIn, pos, null);
        boolean poweredOld = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61360_);
        if (poweredNow && !poweredOld) {
            if (worldIn.m_141902_(pos, Holder.REMOTE_PLACER_TYPE).filter(p -> p.redstoneMode.isPulse()).isPresent()) {
                worldIn.m_186460_(pos, (Block)this, 1);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61360_, (Comparable)Boolean.TRUE), 4);
        } else if (!poweredNow && poweredOld) {
            if (worldIn.m_141902_(pos, Holder.REMOTE_PLACER_TYPE).filter(p -> p.redstoneMode.isPulse()).isPresent()) {
                worldIn.m_186460_(pos, (Block)this, 1);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61360_, (Comparable)Boolean.FALSE), 4);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        super.m_213897_(state, worldIn, pos, rand);
        boolean isPowered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61360_);
        worldIn.m_141902_(pos, Holder.REMOTE_PLACER_TYPE).ifPresent(tile -> {
            if (isPowered) {
                tile.placeBlock();
            } else {
                tile.breakBlock();
            }
        });
    }
}

