/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.Target;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameInsideTarget
extends Target {
    private final Area area;
    private final int minY;
    private final int maxY;
    private int index = 0;

    FrameInsideTarget(Area area, int minY, int maxY) {
        this.area = area;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    @Nullable
    public BlockPos get(boolean goNext) {
        int zSize;
        int xSize = this.area.maxX() - this.area.minX() - 1;
        int areaSize = xSize * (zSize = this.area.maxZ() - this.area.minZ() - 1);
        int y = this.maxY - this.index / areaSize;
        if (y < this.minY) {
            return null;
        }
        int xz = this.index % areaSize;
        int x = this.area.minX() + 1 + xz / zSize;
        int z = this.area.minZ() + 1 + xz % zSize;
        if (goNext) {
            ++this.index;
        }
        return new BlockPos(x, y, z);
    }

    @Override
    @NotNull
    public Stream<BlockPos> allPoses() {
        return BlockPos.m_121886_((int)(this.area.minX() + 1), (int)this.minY, (int)(this.area.minZ() + 1), (int)(this.area.maxX() - 1), (int)this.maxY, (int)(this.area.maxZ() - 1));
    }

    @Override
    @NotNull
    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("area", (Tag)this.area.toNBT());
        tag.m_128405_("minY", this.minY);
        tag.m_128405_("maxY", this.maxY);
        tag.m_128405_("index", this.index);
        return tag;
    }

    @Override
    public double progress() {
        int xSize = this.area.maxX() - this.area.minX() - 1;
        int zSize = this.area.maxZ() - this.area.minZ() - 1;
        int areaSize = xSize * zSize;
        int xz = this.index % areaSize;
        return (double)xz / (double)areaSize;
    }

    public static FrameInsideTarget from(CompoundTag tag) {
        Area area = Area.fromNBT(tag.m_128469_("area")).orElseThrow();
        int minY = tag.m_128451_("minY");
        int maxY = tag.m_128451_("maxY");
        int index = tag.m_128451_("index");
        FrameInsideTarget t = new FrameInsideTarget(area, minY, maxY);
        t.index = index;
        return t;
    }

    public String toString() {
        return "FrameInsideTarget{area=" + this.area + ", minY=" + this.minY + ", maxY=" + this.maxY + ", index=" + this.index + "}";
    }
}

