/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class GemCutTrigger
implements CriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("apotheosis", "gem_cutting");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners == null) {
            ModifierTrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, ModifierTrigger$listeners);
        }
        ModifierTrigger$listeners.add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listener) {
        Listeners ModifierTrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.remove(listener);
            if (ModifierTrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, DeserializationContext conditionsParser) {
        if ((json = json.getAsJsonObject("conditions")) != null) {
            ItemPredicate item = ItemPredicate.m_45051_((JsonElement)json.get("item"));
            String rarity = GsonHelper.m_13851_((JsonObject)json, (String)"rarity", (String)"");
            return new Instance(item, rarity);
        }
        return new Instance(ItemPredicate.f_45028_, "");
    }

    public void trigger(ServerPlayer player, ItemStack stack, String rarity) {
        Listeners ModifierTrigger$listeners = this.listeners.get(player.m_8960_());
        if (ModifierTrigger$listeners != null) {
            ModifierTrigger$listeners.trigger(stack, rarity);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack stack, String rarity) {
            List list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test(stack, rarity)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener1 : list) {
                    listener1.m_13686_(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate gem;
        private final String rarity;

        public Instance(ItemPredicate gem, String rarity) {
            super(ID, EntityPredicate.Composite.f_36667_);
            this.gem = gem;
            this.rarity = rarity;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            return new JsonObject();
        }

        public boolean test(ItemStack stack, String rarity) {
            return this.gem.m_45049_(stack) && (this.rarity.isEmpty() || this.rarity.equals(rarity));
        }
    }
}

