/*
 * Decompiled with CFR 0.152.
 */
package appbot.data;

import appbot.ABItems;
import appbot.AppliedBotanics;
import appeng.core.AppEng;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ItemModelProvider
extends net.minecraftforge.client.model.generators.ItemModelProvider {
    private static final ResourceLocation P2P_TUNNEL_BASE_ITEM = AppEng.makeId((String)"item/p2p_tunnel_base");
    private static final ResourceLocation P2P_TUNNEL_BASE_PART = AppEng.makeId((String)"part/p2p/p2p_tunnel_base");
    private static final ResourceLocation STORAGE_CELL_LED = AppEng.makeId((String)"item/storage_cell_led");
    private static final ResourceLocation PORTABLE_CELL_LED = AppEng.makeId((String)"item/portable_cell_led");
    private static final ResourceLocation MANASTEEL_BLOCK = new ResourceLocation("botania", "block/manasteel_block");

    public ItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "appbot", existingFileHelper);
        existingFileHelper.trackGenerated(P2P_TUNNEL_BASE_ITEM, (ExistingFileHelper.IResourceType)MODEL);
        existingFileHelper.trackGenerated(P2P_TUNNEL_BASE_PART, (ExistingFileHelper.IResourceType)MODEL);
        existingFileHelper.trackGenerated(STORAGE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        existingFileHelper.trackGenerated(PORTABLE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        existingFileHelper.trackGenerated(MANASTEEL_BLOCK, (ExistingFileHelper.IResourceType)TEXTURE);
    }

    protected void registerModels() {
        RegistryObject<Item> housing = ABItems.MANA_CELL_HOUSING;
        this.flatSingleLayer(housing, "item/" + housing.getId().m_135815_());
        RegistryObject<Item> creative = ABItems.MANA_CELL_CREATIVE;
        this.flatSingleLayer(creative, "item/" + creative.getId().m_135815_());
        for (ABItems.Tier tier : ABItems.Tier.values()) {
            RegistryObject<Item> cell = ABItems.get(tier);
            RegistryObject<Item> portableCell = ABItems.getPortable(tier);
            this.cell(cell, "item/" + cell.getId().m_135815_());
            this.portableCell(portableCell, "item/portable_" + cell.getId().m_135815_());
        }
        ((ItemModelBuilder)this.withExistingParent("item/mana_p2p_tunnel", P2P_TUNNEL_BASE_ITEM)).texture("type", MANASTEEL_BLOCK);
        ((ItemModelBuilder)this.withExistingParent("part/mana_p2p_tunnel", P2P_TUNNEL_BASE_PART)).texture("type", MANASTEEL_BLOCK);
    }

    private void cell(RegistryObject<Item> cell, String background) {
        ((ItemModelBuilder)this.singleTexture(cell.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", AppliedBotanics.id(background))).texture("layer1", STORAGE_CELL_LED);
    }

    private void portableCell(RegistryObject<Item> portable, String background) {
        ((ItemModelBuilder)this.singleTexture(portable.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", AppliedBotanics.id(background))).texture("layer1", PORTABLE_CELL_LED);
    }

    private void flatSingleLayer(RegistryObject<Item> item, String texture) {
        this.singleTexture(item.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", AppliedBotanics.id(texture));
    }
}

