/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.me.storage.ExternalStorageFacade;
import java.util.Set;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.util.ChemicalBridge;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

class HandlerStrategy {
    HandlerStrategy() {
    }

    public static ExternalStorageFacade getFacade(final IChemicalHandler handler) {
        return new ExternalStorageFacade(){

            public int getSlots() {
                return handler.getTanks();
            }

            @Nullable
            public GenericStack getStackInSlot(int slot) {
                ChemicalStack stack = handler.getChemicalInTank(slot);
                MekanismKey key = MekanismKey.of(stack);
                if (key == null) {
                    return null;
                }
                return new GenericStack((AEKey)key, stack.getAmount());
            }

            public AEKeyType getKeyType() {
                return MekanismKeyType.TYPE;
            }

            public void getAvailableStacks(KeyCounter out) {
                for (int i = 0; i < handler.getTanks(); ++i) {
                    ChemicalStack stack = handler.getChemicalInTank(i);
                    MekanismKey key = MekanismKey.of(stack);
                    if (key == null || this.extractableOnly && handler.extractChemical(stack, Action.SIMULATE).isEmpty()) continue;
                    out.add((AEKey)key, stack.getAmount());
                }
            }

            protected int insertExternal(AEKey what, int amount, Actionable mode) {
                return (int)HandlerStrategy.insert(handler, what, amount, mode);
            }

            public boolean containsAnyFuzzy(Set<AEKey> keys) {
                for (int i = 0; i < handler.getTanks(); ++i) {
                    MekanismKey what = MekanismKey.of(handler.getChemicalInTank(i));
                    if (what == null || !keys.contains(what.dropSecondary())) continue;
                    return true;
                }
                return false;
            }

            protected int extractExternal(AEKey what, int amount, Actionable mode) {
                return (int)HandlerStrategy.extract(handler, what, amount, mode);
            }
        };
    }

    public static long extract(IChemicalHandler handler, AEKey what, long amount, Actionable mode) {
        if (!(what instanceof MekanismKey)) {
            return 0L;
        }
        MekanismKey key = (MekanismKey)what;
        ChemicalStack<?> stack = ChemicalBridge.withAmount(key.getStack(), amount);
        return handler.extractChemical(stack, Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
    }

    @Nullable
    public static AEKey getStackInTank(int slot, IChemicalHandler handler) {
        ChemicalStack stack = handler.getChemicalInTank(slot);
        return MekanismKey.of(stack);
    }

    public static long insert(IChemicalHandler handler, AEKey what, long amount, Actionable mode) {
        if (what instanceof MekanismKey) {
            MekanismKey key = (MekanismKey)what;
            return amount - handler.insertChemical(ChemicalBridge.withAmount(key.getStack(), amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
        }
        return 0L;
    }
}

