/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.crafting;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FishFilletRecipe
extends CustomRecipe {
    public static final DeferredRegister<RecipeSerializer<?>> IRECIPE_SERIALIZERS_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"aquaculture");
    private static final RegistryObject<RecipeSerializer<?>> FISH_FILLET_SERIALIZER = FishFilletRecipe.registerRecipeSerializer("crafting_special_fish_fillet", new SimpleRecipeSerializer(FishFilletRecipe::new));

    private FishFilletRecipe(ResourceLocation location) {
        super(location);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("aquaculture", "fish_fillet");
    }

    public boolean matches(@Nonnull CraftingContainer craftingInventory, @Nonnull Level world) {
        ItemStack stack = ItemStack.f_41583_;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            ItemStack slotStack = craftingInventory.m_8020_(i);
            if (slotStack.m_41619_()) continue;
            if (AquacultureAPI.FISH_DATA.hasFilletAmount(slotStack.m_41720_())) {
                if (!stack.m_41619_()) {
                    return false;
                }
                stack = slotStack;
                continue;
            }
            if (!slotStack.m_204117_(AquacultureAPI.Tags.FILLET_KNIFE) || !slotStack.m_41763_() && !FishFilletRecipe.isKnifeNeptunium(slotStack.m_41720_()) || !(slotStack.m_41720_() instanceof TieredItem)) {
                return false;
            }
            list.add(slotStack);
        }
        return !stack.m_41619_() && !list.isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer craftingInventory) {
        ItemStack fish = ItemStack.f_41583_;
        Item knife = null;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            ItemStack stackSlot = craftingInventory.m_8020_(i);
            if (stackSlot.m_41619_()) continue;
            Item item = stackSlot.m_41720_();
            if (AquacultureAPI.FISH_DATA.hasFilletAmount(item)) {
                if (!fish.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                fish = stackSlot.m_41777_();
                continue;
            }
            if (!stackSlot.m_204117_(AquacultureAPI.Tags.FILLET_KNIFE)) {
                return ItemStack.f_41583_;
            }
            knife = item;
        }
        if (!fish.m_41619_() && knife != null) {
            int filletAmount = AquacultureAPI.FISH_DATA.getFilletAmount(fish.m_41720_());
            if (((Boolean)AquaConfig.BASIC_OPTIONS.randomWeight.get()).booleanValue() && fish.m_41783_() != null && fish.m_41783_().m_128441_("fishWeight")) {
                filletAmount = FishData.getFilletAmountFromWeight(fish.m_41783_().m_128459_("fishWeight"));
            }
            if (FishFilletRecipe.isKnifeNeptunium(knife)) {
                filletAmount = (int)((float)filletAmount + (float)filletAmount * 0.25f);
            }
            return new ItemStack((ItemLike)AquaItems.FISH_FILLET.get(), filletAmount);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer craftingInventory) {
        NonNullList list = NonNullList.m_122780_((int)craftingInventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = craftingInventory.m_8020_(i);
            if (!stack.m_204117_(AquacultureAPI.Tags.FILLET_KNIFE)) continue;
            ItemStack knife = stack.m_41777_();
            if (!FishFilletRecipe.isKnifeNeptunium(knife.m_41720_()) && knife.m_220157_(1, RandomSource.m_216327_(), null)) {
                knife.m_41774_(1);
            }
            list.set(i, (Object)knife);
        }
        return list;
    }

    public static boolean isKnifeNeptunium(@Nonnull Item knife) {
        return knife instanceof TieredItem && ((TieredItem)knife).m_43314_() == AquacultureAPI.MATS.NEPTUNIUM;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FISH_FILLET_SERIALIZER.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public static RegistryObject<RecipeSerializer<?>> registerRecipeSerializer(String name, RecipeSerializer<?> serializer) {
        return IRECIPE_SERIALIZERS_DEFERRED.register(name, () -> serializer);
    }
}

