/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.xplat.BotaniaConfig;

public class PureDaisyBlockEntity
extends SpecialFlowerBlockEntity {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int RECIPE_COMPLETE_EVENT = 0;
    private static final BlockPos[] POSITIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(1, 0, 0), new BlockPos(1, 0, -1), new BlockPos(0, 0, -1)};
    private int positionAt = 0;
    private final int[] prevTicksRemaining = new int[POSITIONS.length];
    private final int[] ticksRemaining = new int[POSITIONS.length];

    public PureDaisyBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.PURE_DAISY, pos, state);
        Arrays.fill(this.prevTicksRemaining, -1);
        Arrays.fill(this.ticksRemaining, -1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            for (int i = 0; i < POSITIONS.length; ++i) {
                if (this.ticksRemaining[i] <= 0) continue;
                BlockPos coords = this.getEffectivePos().m_121955_((Vec3i)POSITIONS[i]);
                SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), 1.0f, 1.0f, 1.0f, 5);
                this.f_58857_.m_7106_((ParticleOptions)data, (double)coords.m_123341_() + Math.random(), (double)coords.m_123342_() + Math.random(), (double)coords.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        BlockPos acoords = POSITIONS[this.positionAt];
        BlockPos coords = this.getEffectivePos().m_121955_((Vec3i)acoords);
        Level world = this.m_58904_();
        if (!world.m_46859_(coords)) {
            world.m_46473_().m_6180_("findRecipe");
            PureDaisyRecipe recipe = this.findRecipe(coords);
            world.m_46473_().m_7238_();
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.ticksRemaining[this.positionAt] = -1;
                    if (recipe.set(world, coords, this)) {
                        if (BotaniaConfig.common().blockBreakParticles()) {
                            this.m_58904_().m_46796_(2001, coords, Block.m_49956_((BlockState)recipe.getOutputState()));
                        }
                        this.m_58904_().m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, this.positionAt);
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        } else {
            this.ticksRemaining[this.positionAt] = -1;
        }
        if (!Arrays.equals(this.ticksRemaining, this.prevTicksRemaining)) {
            this.m_6596_();
            this.sync();
            System.arraycopy(this.ticksRemaining, 0, this.prevTicksRemaining, 0, POSITIONS.length);
        }
    }

    @Nullable
    private PureDaisyRecipe findRecipe(BlockPos coords) {
        BlockState state = this.m_58904_().m_8055_(coords);
        for (Recipe recipe : BotaniaRecipeTypes.getRecipes(this.f_58857_, BotaniaRecipeTypes.PURE_DAISY_TYPE).values()) {
            PureDaisyRecipe daisyRecipe;
            if (!(recipe instanceof PureDaisyRecipe) || !(daisyRecipe = (PureDaisyRecipe)recipe).matches(this.m_58904_(), coords, this, state)) continue;
            return daisyRecipe;
        }
        return null;
    }

    public boolean m_7531_(int type, int param) {
        switch (type) {
            case 0: {
                if (this.m_58904_().f_46443_) {
                    BlockPos coords = this.getEffectivePos().m_121955_((Vec3i)POSITIONS[param]);
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.m_123341_() + Math.random();
                        double y = (double)coords.m_123342_() + Math.random() + 0.5;
                        double z = (double)coords.m_123343_() + Math.random();
                        WispParticleData data = WispParticleData.wisp((float)Math.random() / 2.0f, 1.0f, 1.0f, 1.0f);
                        this.m_58904_().m_7106_((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
        }
        return super.m_7531_(type, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.positionAt = cmp.m_128451_(TAG_POSITION);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            this.ticksRemaining[i] = cmp.m_128451_(TAG_TICKS_REMAINING + i);
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.m_128405_(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }
}

