/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.BlocksStateIngredient;

public class TagStateIngredient
extends BlocksStateIngredient {
    private final TagKey<Block> tag;

    public TagStateIngredient(ResourceLocation tag) {
        super((Collection<Block>)ImmutableSet.of());
        this.tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tag);
    }

    public Stream<Block> resolve() {
        return StreamSupport.stream(Registry.f_122824_.m_206058_(this.tag).spliterator(), false).map(Holder::m_203334_);
    }

    @Override
    public boolean test(BlockState state) {
        return state.m_204336_(this.tag);
    }

    @Override
    public BlockState pick(RandomSource random) {
        List<Block> values = this.resolve().toList();
        if (values.isEmpty()) {
            return null;
        }
        return values.get(random.m_188503_(values.size())).m_49966_();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "tag");
        object.addProperty("tag", this.tag.f_203868_().toString());
        return object;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.resolve().filter(b -> b.m_5456_() != Items.f_41852_).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Block> getBlocks() {
        return this.resolve().toList();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.resolve().map(Block::m_49966_).collect(Collectors.toList());
    }

    public ResourceLocation getTagId() {
        return this.tag.f_203868_();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.tag.equals(((TagStateIngredient)o).tag);
    }

    @Override
    public int hashCode() {
        return this.tag.hashCode();
    }

    @Override
    public String toString() {
        return "TagStateIngredient{" + this.tag + "}";
    }
}

