/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.FloatingFlowerVariant;

public class GrassSeedsItem
extends Item
implements FloatingFlowerVariant {
    private static final Map<ResourceKey<Level>, Set<BlockSwapper>> blockSwappers = new HashMap<ResourceKey<Level>, Set<BlockSwapper>>();
    private static final Map<FloatingFlower.IslandType, Integer> COLORS = ImmutableMap.builder().put((Object)FloatingFlower.IslandType.GRASS, (Object)26112).put((Object)FloatingFlower.IslandType.PODZOL, (Object)8412672).put((Object)FloatingFlower.IslandType.MYCEL, (Object)6160468).put((Object)FloatingFlower.IslandType.DRY, (Object)6717453).put((Object)FloatingFlower.IslandType.GOLDEN, (Object)12563200).put((Object)FloatingFlower.IslandType.VIVID, (Object)32794).put((Object)FloatingFlower.IslandType.SCORCHED, (Object)0xBF0000).put((Object)FloatingFlower.IslandType.INFUSED, (Object)35980).put((Object)FloatingFlower.IslandType.MUTATED, (Object)0x661A66).build();
    private final FloatingFlower.IslandType type;

    public GrassSeedsItem(FloatingFlower.IslandType type, Item.Properties props) {
        super(props);
        this.type = type;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        return this.applySeeds(world, pos, stack);
    }

    public InteractionResult applySeeds(Level world, BlockPos pos, ItemStack stack) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50440_) && this.type != FloatingFlower.IslandType.GRASS) {
            if (!world.f_46443_) {
                BlockSwapper swapper = GrassSeedsItem.addBlockSwapper(world, pos, this.type);
                world.m_46597_(pos, swapper.stateToSet);
                stack.m_41774_(1);
            } else {
                int color = GrassSeedsItem.getColor(this.type);
                GrassSeedsItem.spawnParticles(world, pos, GrassSeedsItem.extractR(color), GrassSeedsItem.extractG(color), GrassSeedsItem.extractB(color));
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public static void spawnParticles(Level world, BlockPos pos, float r, float g, float b) {
        for (int i = 0; i < 50; ++i) {
            double x = (Math.random() - 0.5) * 3.0;
            double y = Math.random() - 0.5 + 1.0;
            double z = (Math.random() - 0.5) * 3.0;
            float velMul = 0.025f;
            float motionx = (float)(-x) * velMul;
            float motiony = (float)(-y) * velMul;
            float motionz = (float)(-z) * velMul;
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, r, g, b);
            world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.5 + x, (double)pos.m_123342_() + 0.5 + y, (double)pos.m_123343_() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
        }
    }

    public static void onTickEnd(ServerLevel world) {
        ResourceKey dim = world.m_46472_();
        if (blockSwappers.containsKey(dim)) {
            blockSwappers.get(dim).removeIf(next -> next == null || !next.tick());
        }
    }

    private static BlockSwapper addBlockSwapper(Level world, BlockPos pos, FloatingFlower.IslandType type) {
        BlockSwapper swapper = new BlockSwapper(world, pos, GrassSeedsItem.stateForType(type));
        ResourceKey dim = world.m_46472_();
        blockSwappers.computeIfAbsent((ResourceKey<Level>)dim, d -> new HashSet()).add(swapper);
        return swapper;
    }

    private static BlockState stateForType(FloatingFlower.IslandType type) {
        if (type == FloatingFlower.IslandType.PODZOL) {
            return Blocks.f_50599_.m_49966_();
        }
        if (type == FloatingFlower.IslandType.MYCEL) {
            return Blocks.f_50195_.m_49966_();
        }
        if (type == FloatingFlower.IslandType.DRY) {
            return BotaniaBlocks.dryGrass.m_49966_();
        }
        if (type == FloatingFlower.IslandType.GOLDEN) {
            return BotaniaBlocks.goldenGrass.m_49966_();
        }
        if (type == FloatingFlower.IslandType.VIVID) {
            return BotaniaBlocks.vividGrass.m_49966_();
        }
        if (type == FloatingFlower.IslandType.SCORCHED) {
            return BotaniaBlocks.scorchedGrass.m_49966_();
        }
        if (type == FloatingFlower.IslandType.INFUSED) {
            return BotaniaBlocks.infusedGrass.m_49966_();
        }
        if (type == FloatingFlower.IslandType.MUTATED) {
            return BotaniaBlocks.mutatedGrass.m_49966_();
        }
        return Blocks.f_50440_.m_49966_();
    }

    public static float extractR(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float extractG(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float extractB(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int getColor(FloatingFlower.IslandType type) {
        return COLORS.get(type);
    }

    @Override
    public FloatingFlower.IslandType getIslandType(ItemStack stack) {
        return this.type;
    }

    private static class BlockSwapper {
        public static final int RANGE = 3;
        public static final int TICK_RANGE = 1;
        private final Level world;
        private final Random rand;
        private final BlockState stateToSet;
        private final BlockPos startCoords;
        private int ticksExisted = 0;

        public BlockSwapper(Level world, BlockPos coords, BlockState state) {
            this.world = world;
            this.stateToSet = state;
            this.rand = new Random(coords.hashCode());
            this.startCoords = coords;
        }

        public boolean tick() {
            if (++this.ticksExisted % 20 == 0) {
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.startCoords.m_7918_(-3, 0, -3), (BlockPos)this.startCoords.m_7918_(3, 0, 3))) {
                    if (this.world.m_8055_(pos) != this.stateToSet) continue;
                    this.tickBlock(pos);
                }
            }
            return this.ticksExisted < 80;
        }

        public void tickBlock(BlockPos pos) {
            ArrayList<BlockPos> validCoords = new ArrayList<BlockPos>();
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0 || !this.isValidSwapPosition(pos.m_7918_(xOffset, 0, zOffset))) continue;
                    validCoords.add(pos.m_7918_(xOffset, 0, zOffset));
                }
            }
            if (!validCoords.isEmpty()) {
                BlockPos toSwap = (BlockPos)validCoords.get(this.rand.nextInt(validCoords.size()));
                this.world.m_46597_(toSwap, this.stateToSet);
            }
        }

        public boolean isValidSwapPosition(BlockPos pos) {
            BlockState state = this.world.m_8055_(pos);
            return (state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50440_)) && this.world.m_8055_(pos.m_7494_()).m_60739_((BlockGetter)this.world, pos.m_7494_()) <= 1;
        }
    }
}

