/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RelicBaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class RingOfOdinItem
extends RelicBaubleItem {
    private static final Set<String> damageNegations = new HashSet<String>();

    public RingOfOdinItem(Item.Properties props) {
        super(props);
        damageNegations.add(DamageSource.f_19312_.f_19326_);
        damageNegations.add(DamageSource.f_19315_.f_19326_);
        damageNegations.add(DamageSource.f_19310_.f_19326_);
        damageNegations.add(DamageSource.f_19313_.f_19326_);
        damageNegations.add(DamageSource.f_19316_.f_19326_);
    }

    @Override
    public void onValidPlayerWornTick(Player player) {
        if (player.m_6060_()) {
            player.m_20095_();
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(RingOfOdinItem.getBaubleUUID(stack), "Odin Ring", 20.0, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    public static boolean onPlayerAttacked(Player player, DamageSource src) {
        return (src.m_19384_() || damageNegations.contains(src.f_19326_)) && !EquipmentHandler.findOrEmpty(BotaniaItems.odinRing, (LivingEntity)player).m_41619_();
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/odin_ring"));
    }
}

