/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model.parsing;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BlockModel;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.model.IModelParser;
import team.chisel.ctm.client.model.ModelCTM;

public class ModelParserV1
implements IModelParser {
    private static final Gson GSON = new Gson();

    @Override
    @Nonnull
    public IModelCTM fromJson(JsonDeserializationContext ctx, JsonObject json) {
        BlockModel modelinfo = (BlockModel)ctx.deserialize((JsonElement)json, BlockModel.class);
        Map parsed = (Map)GSON.fromJson((JsonElement)json.getAsJsonObject("ctm_overrides"), new TypeToken<Map<String, JsonElement>>(){}.getType());
        if (parsed == null) {
            parsed = Collections.emptyMap();
        }
        Int2ObjectArrayMap replacements = new Int2ObjectArrayMap(parsed.size());
        for (Map.Entry e : parsed.entrySet()) {
            try {
                int index = Integer.parseInt((String)e.getKey());
                replacements.put(index, (Object)((JsonElement)e.getValue()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new ModelCTM(modelinfo, (Int2ObjectMap<JsonElement>)replacements);
    }
}

