/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.icon;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;

@OnlyIn(value=Dist.CLIENT)
public class IconProvider {
    private final ClientProxyComponent clientProxy;
    private final List<Pair<Pair<Object, Field>, String>> toRegister = Lists.newLinkedList();

    public IconProvider(ClientProxyComponent clientProxy) {
        this.clientProxy = clientProxy;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onPreTextureStitch);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onPostTextureStitch);
    }

    protected void registerIcon(Object object, Field field, String location) {
        this.toRegister.add((Pair<Pair<Object, Field>, String>)Pair.of((Object)Pair.of((Object)object, (Object)field), (Object)location));
    }

    protected TextureAtlasSprite registerIcon(TextureAtlas textureMap, String location) {
        return textureMap.m_118316_(new ResourceLocation(this.clientProxy.getMod().getModId(), location));
    }

    protected ResourceLocation getIconId(String location) {
        return new ResourceLocation(this.clientProxy.getMod().getModId(), location);
    }

    public void onPreTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            for (Pair<Pair<Object, Field>, String> entry : this.toRegister) {
                event.addSprite(this.getIconId((String)entry.getValue()));
            }
        }
    }

    public void onPostTextureStitch(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            for (Pair<Pair<Object, Field>, String> entry : this.toRegister) {
                TextureAtlasSprite icon = event.getAtlas().m_118316_(this.getIconId((String)entry.getValue()));
                Object object = ((Pair)entry.getLeft()).getLeft();
                Field field = (Field)((Pair)entry.getLeft()).getRight();
                try {
                    field.set(object, icon);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("The icon field %s in class %s could not be set.", field.getName(), object.getClass().getCanonicalName()));
                }
            }
        }
    }

    public void registerIconHolderObject(Object object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Icon.class)) continue;
                Icon annotation = field.getAnnotation(Icon.class);
                this.registerIcon(object, field, annotation.location());
            }
        }
    }
}

