/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class FluidConfig
extends ExtendedConfig<FluidConfig, ForgeFlowingFluid.Properties> {
    public FluidConfig(ModBase mod, String namedId, Function<FluidConfig, ForgeFlowingFluid.Properties> elementConstructor) {
        super(mod, namedId, elementConstructor);
    }

    protected static ForgeFlowingFluid.Properties getDefaultFluidProperties(final ModBase mod, final String texturePrefixPath, Consumer<FluidType.Properties> fluidAttributesConsumer) {
        FluidType.Properties fluidAttributes = FluidType.Properties.create();
        fluidAttributesConsumer.accept(fluidAttributes);
        FluidType fluidType = new FluidType(fluidAttributes){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private final ResourceLocation STILL;
                    private final ResourceLocation FLOW;
                    {
                        this.STILL = new ResourceLocation(mod.getModId(), texturePrefixPath + "_still");
                        this.FLOW = new ResourceLocation(mod.getModId(), texturePrefixPath + "_flow");
                    }

                    public ResourceLocation getStillTexture() {
                        return this.STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return this.FLOW;
                    }
                });
            }
        };
        Wrapper<ForgeFlowingFluid.Properties> properties = new Wrapper<ForgeFlowingFluid.Properties>();
        Wrapper source = new Wrapper();
        Wrapper flowing = new Wrapper();
        properties.set(new ForgeFlowingFluid.Properties(() -> fluidType, () -> {
            if (source.get() == null) {
                source.set(new ForgeFlowingFluid.Source((ForgeFlowingFluid.Properties)properties.get()));
            }
            return (Fluid)source.get();
        }, () -> {
            if (flowing.get() == null) {
                flowing.set(new ForgeFlowingFluid.Flowing((ForgeFlowingFluid.Properties)properties.get()));
            }
            return (Fluid)flowing.get();
        }));
        return (ForgeFlowingFluid.Properties)properties.get();
    }

    @Override
    public String getTranslationKey() {
        return "block." + this.getMod().getModId() + ".block_" + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.FLUID;
    }

    public ResourceLocation getIconLocationStill() {
        return new ResourceLocation(this.getMod().getModId(), "blocks/" + this.getNamedId() + "_still");
    }

    public ResourceLocation getIconLocationFlow() {
        return new ResourceLocation(this.getMod().getModId(), "blocks/" + this.getNamedId() + "_flow");
    }
}

