/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class LocationHelpers {
    private static final Random random = new Random();

    public static PacketDistributor.TargetPoint createTargetPointFromEntity(Entity entity, int range) {
        return new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (double)range, entity.f_19853_.m_46472_());
    }

    public static PacketDistributor.TargetPoint createTargetPointFromLocation(Level world, BlockPos location, int range) {
        return new PacketDistributor.TargetPoint((double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_(), (double)range, world.m_46472_());
    }

    public static BlockPos getRandomPointInSphere(BlockPos center, int radius) {
        BlockPos randomPoint = null;
        while (randomPoint == null) {
            BlockPos coordinates = center.m_7918_(-radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius));
            double totalDistance = center.m_123331_((Vec3i)coordinates);
            if ((int)Math.sqrt(totalDistance) > radius) continue;
            randomPoint = coordinates;
        }
        return randomPoint;
    }

    public static BlockPos copyLocation(BlockPos blockPos) {
        return new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static Vec3i copyLocation(Vec3i blockPos) {
        return new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    public static BlockPos addToDimension(BlockPos blockPos, int dimension, int value) {
        if (dimension == 0) {
            return blockPos.m_7918_(value, 0, 0);
        }
        if (dimension == 1) {
            return blockPos.m_7918_(0, value, 0);
        }
        if (dimension == 2) {
            return blockPos.m_7918_(0, 0, value);
        }
        return blockPos;
    }

    public static BlockPos fromArray(int[] coordinates) {
        return new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
    }

    public static int[] toArray(Vec3i blockPos) {
        return new int[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()};
    }

    public static BlockPos subtract(BlockPos blockPos, Vec3i vec) {
        return new BlockPos(blockPos.m_123341_() - vec.m_123341_(), blockPos.m_123342_() - vec.m_123342_(), blockPos.m_123343_() - vec.m_123343_());
    }

    public static Vec3i subtract(Vec3i vec1, Vec3i vec2) {
        return new Vec3i(vec1.m_123341_() - vec2.m_123341_(), vec1.m_123342_() - vec2.m_123342_(), vec1.m_123343_() - vec2.m_123343_());
    }

    public static double getYaw(BlockPos start, BlockPos end) {
        double dX = start.m_123341_() - end.m_123341_();
        double dY = start.m_123342_() - end.m_123342_();
        double dZ = start.m_123343_() - end.m_123343_();
        return Math.atan2(dZ, dX) * 180.0 / Math.PI;
    }

    public static double getPitch(BlockPos start, BlockPos end) {
        double dX = start.m_123341_() - end.m_123341_();
        double dY = start.m_123342_() - end.m_123342_();
        double dZ = start.m_123343_() - end.m_123343_();
        return (Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI) * 180.0 / Math.PI;
    }

    public static String toCompactString(BlockPos pos) {
        return String.format("x: %s ; y: %s ;z: %s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static String toCompactString(Vec3i vec) {
        return String.format("%sx%sx%s", vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }
}

