/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ValueNotifyPacket
extends PacketCodec {
    @CodecField
    private String containerType;
    @CodecField
    private int valueId;
    @CodecField
    private CompoundTag value;

    public ValueNotifyPacket() {
    }

    public ValueNotifyPacket(MenuType<?> containerType, int valueId, CompoundTag value) {
        this.containerType = ForgeRegistries.MENU_TYPES.getKey(containerType).toString();
        this.valueId = valueId;
        this.value = value;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    protected boolean isContainerValid(IValueNotifiable container) {
        return ForgeRegistries.MENU_TYPES.getKey(container.getValueNotifiableType()).toString().equals(this.containerType);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level level, Player player) {
        IValueNotifiable container;
        if (player.f_36096_ instanceof IValueNotifiable && this.isContainerValid(container = (IValueNotifiable)player.f_36096_)) {
            container.onUpdate(this.valueId, this.value);
        }
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
        IValueNotifiable container;
        if (player.f_36096_ instanceof IValueNotifiable && this.isContainerValid(container = (IValueNotifiable)player.f_36096_)) {
            container.onUpdate(this.valueId, this.value);
        }
    }
}

