/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.data.gen;

import java.util.Objects;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.ISliceable;
import net.brnbrd.delightful.common.block.MiniBlock;
import net.brnbrd.delightful.common.block.SalmonberryBushBlock;
import net.brnbrd.delightful.common.block.SlicedMiniMelonBlock;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class DelightfulBlockStateProvider
extends BlockStateProvider {
    public DelightfulBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "delightful", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.wildCropBlock((Block)DelightfulBlocks.WILD_SALMONBERRIES.get());
        this.stageBlock((Block)DelightfulBlocks.SALMONBERRY_BUSH.get(), SalmonberryBushBlock.AGE);
        this.simpleBlock((Block)DelightfulBlocks.SALMONBERRY_SACK.get(), (ModelFile)this.models().cubeBottomTop("salmonberry_sack", Util.rl("delightful", "block/salmonberry_sack"), Util.rl("delightful", "block/salmonberry_sack_bottom"), Util.rl("delightful", "block/salmonberry_sack_top")));
        this.simpleBlock((Block)DelightfulBlocks.ACORN_SACK.get(), (ModelFile)this.models().cubeBottomTop("acorn_sack", Util.rl("delightful", "block/acorn_sack"), Util.rl("delightful", "block/acorn_sack_bottom"), Util.rl("delightful", "block/acorn_sack_top")));
        this.miniBlock((MiniBlock)((Object)DelightfulBlocks.CANTALOUPE.get()), this.resourceBlock("cantaloupe_side_small"), this.resourceBlock("cantaloupe_top"));
        this.miniBlock((MiniBlock)((Object)DelightfulBlocks.MINI_MELON.get()), Util.rl("minecraft", "block/melon_side"), Util.rl("minecraft", "block/melon_top"));
        this.slicedMiniMelonBlock((SlicedMiniMelonBlock)DelightfulBlocks.SLICED_MINI_MELON.get(), "melon", Util.rl("minecraft", "block/melon_side"), Util.rl("minecraft", "block/melon_top"));
        this.slicedMiniMelonBlock((SlicedMiniMelonBlock)DelightfulBlocks.SLICED_CANTALOUPE.get(), "cantaloupe", this.resourceBlock("cantaloupe_side_small"), this.resourceBlock("cantaloupe_top"));
        this.bigSlicedBlock((Block)DelightfulBlocks.SLICED_MELON.get(), this.resourceBlock("melon_inside_rind"), Util.rl("minecraft", "block/melon_side"), Util.rl("minecraft", "block/melon_top"));
        this.bigSlicedBlock((Block)DelightfulBlocks.SLICED_PUMPKIN.get(), this.resourceBlock("pumpkin_inside_rind"), Util.rl("minecraft", "block/pumpkin_side"), Util.rl("minecraft", "block/pumpkin_top"));
        this.pieBlock(DelightfulBlocks.SALMONBERRY_PIE);
        this.pieBlock(DelightfulBlocks.PUMPKIN_PIE);
        this.pieBlock(DelightfulBlocks.SOURCE_BERRY_PIE);
        this.pieBlock(DelightfulBlocks.GREEN_APPLE_PIE);
        this.pieBlock(DelightfulBlocks.BLUEBERRY_PIE);
        this.pieBlock(DelightfulBlocks.CRIMSON_BERRY_PIE);
        this.pieBlock(DelightfulBlocks.NIGHTSHADE_BERRY_PIE);
        this.cabinet((Block)DelightfulBlocks.BASALT_CABINET.get());
        this.cabinet((Block)DelightfulBlocks.QUARTZ_CABINET.get());
        this.simpleBlock((Block)DelightfulBlocks.SALMONBERRY_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)DelightfulBlocks.MATCHA_ICE_CREAM_BLOCK.get());
    }

    public void stageBlock(Block block, IntegerProperty ageProperty) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String stageName = Util.name(block) + "_stage" + state.m_61143_((Property)ageProperty);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        });
    }

    public void wildCropBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(Util.name(block), this.resourceBlock(Util.name(block)))).renderType("cutout"));
    }

    public void cabinet(Block block) {
        String path = Util.name(block);
        String type = path.replace("_cabinet", "").trim();
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientableWithBottom(path + suffix, this.resourceBlock(type + "_cabinet_side"), this.resourceBlock(type + "_cabinet_front" + suffix), this.resourceBlock(type + "_cabinet_bottom"), this.resourceBlock(type + "_cabinet_top"));
        });
    }

    public void miniBlock(MiniBlock block, ResourceLocation side, ResourceLocation top) {
        this.simpleBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Util.name((Block)block))).ao(false)).texture("side", side)).texture("top", top)).texture("particle", side)).element().from(3.0f, 0.0f, 3.0f).to(13.0f, 10.0f, 13.0f).face(Direction.NORTH).texture("#side").end().face(Direction.EAST).texture("#side").end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.UP).texture("#top").end().face(Direction.DOWN).texture("#top").end().end()).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemTransforms.TransformType.GUI).rotation(30.0f, 225.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemTransforms.TransformType.HEAD).translation(0.0f, 14.25f, 0.0f).end().transform(ItemTransforms.TransformType.FIXED).scale(0.5f, 0.5f, 0.5f).end().end());
    }

    public void bigSlicedBlock(Block block, ResourceLocation inside, ResourceLocation side, ResourceLocation top) {
        if (block instanceof ISliceable) {
            ISliceable slice = (ISliceable)block;
            String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            this.getVariantBuilder(block).forAllStates(state -> {
                int bites = (Integer)state.m_61143_((Property)slice.getBitesProperty());
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_bite" + bites)).ao(false)).texture("inside", inside)).texture("side", side)).texture("top", top)).texture("particle", side)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, slice.getHeight(bites), 16.0f).face(Direction.NORTH).texture("#side").end().face(Direction.EAST).texture("#side").end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.UP).texture("#inside").end().face(Direction.DOWN).texture("#top").end().end()).build();
            });
        }
    }

    public void slicedMiniMelonBlock(SlicedMiniMelonBlock block, String alias, ResourceLocation side, ResourceLocation top) {
        String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)block.getBitesProperty());
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_bite" + bites)).ao(false)).texture("inside", this.resourceBlock(alias + "_inside_small"))).texture("side", side)).texture("top", top)).texture("particle", side)).element().from(3.0f, 0.0f, 3.0f).to(13.0f, block.getHeight(bites), 13.0f).face(Direction.NORTH).texture("#side").end().face(Direction.EAST).texture("#side").end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.UP).uvs(3.0f, 6.0f, 13.0f, 16.0f).texture("#inside").end().face(Direction.DOWN).texture("#top").end().end()).transforms().transform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemTransforms.TransformType.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemTransforms.TransformType.GUI).rotation(30.0f, 225.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemTransforms.TransformType.HEAD).translation(0.0f, 14.25f, 0.0f).end().transform(ItemTransforms.TransformType.FIXED).scale(0.5f, 0.5f, 0.5f).end().end()).build();
        });
    }

    public void pieBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            String name = Util.name(block);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + (String)suffix, Util.rl("farmersdelight", "pie" + (String)suffix))).texture("top", this.resourceBlock(name + "_top"))).texture("bottom", this.resourceBlock(name + "_bottom"))).texture("side", this.resourceBlock(name + "_side"))).texture("particle", this.resourceBlock(name + "_top"));
            if (bites > 0) {
                mod.texture("inner", this.resourceBlock(name + "_inner"));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public ResourceLocation resourceBlock(String path) {
        return Util.rl("delightful", "block/" + path);
    }
}

