/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.manager;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.DimStoragePlugin;
import edivad.dimstorage.api.Frequency;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DimStorageManager {
    private static DimStorageManager serverManager;
    private static DimStorageManager clientManager;
    private static HashMap<String, DimStoragePlugin> plugins;
    private Map<String, AbstractDimStorage> storageMap;
    private Map<String, List<AbstractDimStorage>> storageList;
    private final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractDimStorage> dirtyStorage;
    private CompoundTag saveTag;

    public DimStorageManager(boolean client) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (String key : plugins.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
        if (this.isServer()) {
            this.load();
        }
    }

    public boolean isServer() {
        return !this.client;
    }

    private void sendClientInfo(Player player) {
        for (Map.Entry<String, DimStoragePlugin> plugin : plugins.entrySet()) {
            plugin.getValue().sendClientInfo(player, this.storageList.get(plugin.getKey()));
        }
    }

    private void load() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer().m_129783_().m_7654_();
        this.saveDir = new File(minecraftServer.m_129843_(LevelResource.f_78182_).toFile(), "DimStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    DataInputStream din = new DataInputStream(new FileInputStream(this.saveFiles[this.saveTo ^ 1]));
                    this.saveTag = NbtIo.m_128939_((InputStream)din);
                    din.close();
                } else {
                    this.saveTag = new CompoundTag();
                }
            } else {
                this.saveTag = new CompoundTag();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("DimStorage was unable to read it's data, please delete the 'DimStorage' folder Here: %s and start the server again.", this.saveDir), e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractDimStorage inv : this.dirtyStorage) {
                this.saveTag.m_128365_(inv.freq + ",type=" + inv.type(), (Tag)inv.saveToTag());
                inv.setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                NbtIo.m_128947_((CompoundTag)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client) {
        DimStorageManager newManager = new DimStorageManager(client);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public static DimStorageManager instance(boolean client) {
        DimStorageManager manager;
        DimStorageManager dimStorageManager = manager = client ? clientManager : serverManager;
        if (manager == null) {
            DimStorageManager.reloadManager(client);
            manager = client ? clientManager : serverManager;
        }
        return manager;
    }

    public AbstractDimStorage getStorage(Frequency freq, String type) {
        String key = freq + ",type=" + type;
        AbstractDimStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = plugins.get(type).createDimStorage(this, freq);
            if (!this.client && this.saveTag.m_128441_(key)) {
                storage.loadFromTag(this.saveTag.m_128469_(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    public static void registerPlugin(DimStoragePlugin plugin) {
        plugins.put(plugin.identifier(), plugin);
        if (serverManager != null) {
            DimStorageManager.serverManager.storageList.put(plugin.identifier(), new ArrayList());
        }
        if (clientManager != null) {
            DimStorageManager.clientManager.storageList.put(plugin.identifier(), new ArrayList());
        }
    }

    public void requestSave(AbstractDimStorage storage) {
        this.dirtyStorage.add(storage);
    }

    static {
        plugins = new HashMap();
    }

    public static class DimStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            if (event.getLevel().m_5776_()) {
                DimStorageManager.reloadManager(true);
            }
        }

        @SubscribeEvent
        public void onWorldSave(LevelEvent.Save event) {
            if (!event.getLevel().m_5776_() && DimStorageManager.instance(false) != null) {
                DimStorageManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            DimStorageManager.instance(false).sendClientInfo(event.getEntity());
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            DimStorageManager.instance(false).sendClientInfo(event.getEntity());
        }
    }
}

