/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.server.ServerLifecycleHooks;
import top.seraphjack.simplelogin.SLConstants;
import top.seraphjack.simplelogin.server.handler.HandlerPlugin;
import top.seraphjack.simplelogin.server.handler.plugins.AutoSave;
import top.seraphjack.simplelogin.server.handler.plugins.ProtectCoord;
import top.seraphjack.simplelogin.server.handler.plugins.ResendRequest;
import top.seraphjack.simplelogin.server.handler.plugins.RestrictGameType;
import top.seraphjack.simplelogin.server.handler.plugins.RestrictMovement;
import top.seraphjack.simplelogin.server.handler.plugins.Timeout;
import top.seraphjack.simplelogin.server.storage.StorageProvider;
import top.seraphjack.simplelogin.server.storage.StorageProviderFile;
import top.seraphjack.simplelogin.server.storage.StorageProviderSQLite;

public class SLRegistries<S> {
    private final Map<ResourceLocation, Supplier<? extends S>> plugins = new HashMap<ResourceLocation, Supplier<? extends S>>();
    public static final SLRegistries<HandlerPlugin> PLUGINS = new SLRegistries();
    public static final SLRegistries<StorageProvider> STORAGE_PROVIDERS = new SLRegistries();

    public synchronized void register(ResourceLocation rl, Supplier<? extends S> plugin) {
        if (this.plugins.containsKey(rl)) {
            throw new IllegalArgumentException("Resource location " + rl.toString() + " already exists.");
        }
        this.plugins.put(rl, plugin);
    }

    public Optional<Supplier<? extends S>> get(ResourceLocation rl) {
        return Optional.ofNullable(this.plugins.get(rl));
    }

    public Set<ResourceLocation> list() {
        return this.plugins.keySet();
    }

    private SLRegistries() {
    }

    private static <S> S mustCall(Callable<S> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PLUGINS.register(new ResourceLocation("simplelogin", "auto_save"), AutoSave::new);
        PLUGINS.register(new ResourceLocation("simplelogin", "protect_coord"), ProtectCoord::new);
        PLUGINS.register(new ResourceLocation("simplelogin", "resend_request"), ResendRequest::new);
        PLUGINS.register(new ResourceLocation("simplelogin", "restrict_game_type"), RestrictGameType::new);
        PLUGINS.register(new ResourceLocation("simplelogin", "restrict_movement"), RestrictMovement::new);
        PLUGINS.register(new ResourceLocation("simplelogin", "timeout"), Timeout::new);
        STORAGE_PROVIDERS.register(new ResourceLocation("simplelogin", "file"), () -> SLRegistries.mustCall(() -> new StorageProviderFile(ServerLifecycleHooks.getCurrentServer().m_129843_(SLConstants.SL_ENTRY))));
        STORAGE_PROVIDERS.register(new ResourceLocation("simplelogin", "sqlite"), () -> SLRegistries.mustCall(StorageProviderSQLite::new));
    }
}

