/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.setup.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedCrafterNetworkNode
extends NetworkNode
implements ICraftingPatternContainer {
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_LOCKED = "Locked";
    private static final String NBT_WAS_POWERED = "WasPowered";
    private static final String NBT_TIER = "Tier";
    private final Component DEFAULT_NAME;
    private final BaseItemHandler patternsInventory;
    private final Map<Integer, ICraftingPattern> slot_to_pattern = new HashMap<Integer, ICraftingPattern>();
    private final List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final ResourceLocation ID;
    private boolean visited = false;
    private CrafterMode mode = CrafterMode.IGNORE;
    private boolean locked = false;
    private boolean wasPowered;
    @Nullable
    private Component displayName;
    @Nullable
    private UUID uuid = null;
    private CrafterTier tier;

    public AdvancedCrafterNetworkNode(Level level, BlockPos pos, CrafterTier tier) {
        super(level, pos);
        this.tier = tier;
        this.patternsInventory = new BaseItemHandler(this.tier.getSlots()){

            public int getSlotLimit(int slot) {
                return 1;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!((ItemStack)this.stacks.get(slot)).m_41619_()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        }.addValidator((Predicate)new PatternItemValidator(level)).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
            if (!reading) {
                if (!level.f_46443_) {
                    this.invalidateSlot(slot);
                }
                if (this.network != null) {
                    this.network.getCraftingManager().invalidate();
                }
            }
        });
        this.DEFAULT_NAME = Component.m_237115_((String)("block.extrastorage." + this.tier.getID()));
        this.ID = new ResourceLocation("extrastorage", tier.getID());
    }

    private void invalidate() {
        this.slot_to_pattern.clear();
        this.patterns.clear();
        for (int i = 0; i < this.patternsInventory.getSlots(); ++i) {
            this.invalidateSlot(i);
        }
    }

    private void invalidateSlot(int slot) {
        ICraftingPattern pattern;
        ItemStack patternStack;
        if (this.slot_to_pattern.containsKey(slot)) {
            this.patterns.remove(this.slot_to_pattern.remove(slot));
        }
        if (!(patternStack = this.patternsInventory.getStackInSlot(slot)).m_41619_() && (pattern = ((ICraftingPatternProvider)patternStack.m_41720_()).create(this.level, patternStack, (ICraftingPatternContainer)this)).isValid()) {
            this.slot_to_pattern.put(slot, pattern);
            this.patterns.add(pattern);
        }
    }

    public int getEnergyUsage() {
        int energyPatterns = (Boolean)Config.AdvancedCrafter.INCLUDE_PATTERN_ENERGY.get() != false ? 2 * this.patterns.size() : 0;
        int energyCrafter = (Integer)Config.AdvancedCrafter.BASE_ENERGY.get() * (this.tier.ordinal() + 1);
        return energyCrafter + this.upgrades.getEnergyUsage() + energyPatterns;
    }

    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET && this.level.m_46749_(this.pos)) {
            if (this.level.m_46753_(this.pos)) {
                this.wasPowered = true;
                this.markDirty();
            } else if (this.wasPowered) {
                this.wasPowered = false;
                this.locked = false;
                this.markDirty();
            }
        }
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        network.getCraftingManager().invalidate();
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    public void onDirectionChanged(Direction direction) {
        super.onDirectionChanged(direction);
        if (this.network != null) {
            this.network.getCraftingManager().invalidate();
        }
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.patternsInventory, (int)0, (CompoundTag)tag);
        this.invalidate();
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        if (tag.m_128441_(NBT_DISPLAY_NAME)) {
            this.displayName = Component.Serializer.m_130701_((String)tag.m_128461_(NBT_DISPLAY_NAME));
        }
        if (tag.m_128403_(NBT_UUID)) {
            this.uuid = tag.m_128342_(NBT_UUID);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = CrafterMode.getById(tag.m_128451_(NBT_MODE));
        }
        if (tag.m_128441_(NBT_LOCKED)) {
            this.locked = tag.m_128471_(NBT_LOCKED);
        }
        if (tag.m_128441_(NBT_WAS_POWERED)) {
            this.wasPowered = tag.m_128471_(NBT_WAS_POWERED);
        }
        if (tag.m_128441_(NBT_TIER)) {
            this.tier = CrafterTier.values()[tag.m_128451_(NBT_TIER)];
        }
    }

    public ResourceLocation getId() {
        return this.ID;
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patternsInventory, (int)0, (CompoundTag)tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        if (this.displayName != null) {
            tag.m_128359_(NBT_DISPLAY_NAME, Component.Serializer.m_130703_((Component)this.displayName));
        }
        if (this.uuid != null) {
            tag.m_128362_(NBT_UUID, this.uuid);
        }
        tag.m_128405_(NBT_MODE, this.mode.ordinal());
        tag.m_128379_(NBT_LOCKED, this.locked);
        tag.m_128379_(NBT_WAS_POWERED, this.wasPowered);
        tag.m_128405_(NBT_TIER, this.tier.ordinal());
        return tag;
    }

    public int getUpdateInterval() {
        int upgradesCount = this.upgrades.getUpgradeCount(UpgradeItem.Type.SPEED);
        if (upgradesCount < 0 || upgradesCount > 4) {
            return 0;
        }
        return 10 - upgradesCount * 2;
    }

    public int getMaximumSuccessfulCraftingUpdates() {
        int speed = this.getTierSpeed();
        if (this.hasConnectedInventory()) {
            return Math.min(speed, this.getConnectedInventory().getSlots());
        }
        return speed;
    }

    public int getTierSpeed() {
        int upgradesCount = this.upgrades.getUpgradeCount(UpgradeItem.Type.SPEED);
        if (this.tier.equals((Object)CrafterTier.IRON)) {
            return upgradesCount + this.tier.getCraftingSpeed();
        }
        return upgradesCount * (this.tier.getCraftingSpeed() / 5) + this.tier.getCraftingSpeed();
    }

    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return LevelUtils.getItemHandler((BlockEntity)proxy.getFacingBlockEntity(), (Direction)proxy.getDirection().m_122424_());
    }

    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return LevelUtils.getFluidHandler((BlockEntity)proxy.getFacingBlockEntity(), (Direction)proxy.getDirection().m_122424_());
    }

    @Nullable
    public BlockEntity getConnectedBlockEntity() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingBlockEntity();
    }

    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    public Component getName() {
        Nameable face;
        if (this.displayName != null) {
            return this.displayName;
        }
        BlockEntity facing = this.getConnectedBlockEntity();
        if (facing instanceof Nameable && (face = (Nameable)facing).m_7755_() != null) {
            return face.m_7755_();
        }
        if (facing != null) {
            return Component.m_237115_((String)this.level.m_8055_(facing.m_58899_()).m_60734_().m_7705_());
        }
        return this.DEFAULT_NAME;
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public CrafterMode getMode() {
        return this.mode;
    }

    public void setMode(CrafterMode mode) {
        this.mode = mode;
        this.wasPowered = false;
        this.locked = false;
        this.markDirty();
    }

    public IItemHandler getPatternItems() {
        return this.patternsInventory;
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Nullable
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patternsInventory, this.upgrades});
    }

    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        ICraftingPatternContainer container;
        block5: {
            block4: {
                if (this.visited) {
                    return null;
                }
                INetworkNode facing = API.instance().getNetworkNodeManager((ServerLevel)this.level).getNode(this.pos.m_121945_(this.getDirection()));
                if (!(facing instanceof ICraftingPatternContainer)) break block4;
                container = (ICraftingPatternContainer)facing;
                if (facing.getNetwork() == this.network) break block5;
            }
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = container.getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    public Optional<ICraftingPatternContainer> getRootContainerNotSelf() {
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && root != this) {
            return Optional.of(root);
        }
        return Optional.empty();
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public boolean isLocked() {
        return this.getRootContainerNotSelf().map(ICraftingPatternContainer::isLocked).orElseGet(() -> switch (this.mode) {
            case CrafterMode.SIGNAL_LOCKS_AUTOCRAFTING -> this.level.m_46753_(this.pos);
            case CrafterMode.SIGNAL_UNLOCKS_AUTOCRAFTING -> !this.level.m_46753_(this.pos);
            case CrafterMode.PULSE_INSERTS_NEXT_SET -> this.locked;
            default -> false;
        });
    }

    public void unlock() {
        this.locked = false;
    }

    public void onUsedForProcessing() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            root.get().onUsedForProcessing();
        } else if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            this.locked = true;
            this.markDirty();
        }
    }

    public static enum CrafterMode {
        IGNORE,
        SIGNAL_UNLOCKS_AUTOCRAFTING,
        SIGNAL_LOCKS_AUTOCRAFTING,
        PULSE_INSERTS_NEXT_SET;


        public static CrafterMode getById(int id) {
            if (id >= 0 && id < CrafterMode.values().length) {
                return CrafterMode.values()[id];
            }
            return IGNORE;
        }
    }
}

