/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import sonar.fluxnetworks.api.gui.EnumNetworkColor;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.common.util.FluxUtils;

public class SwitchButton
extends GuiButtonCore {
    private static final int WIDTH = 16;
    private static final int HEIGHT = 8;
    private boolean mChecked = false;
    private float mOffset;
    private int mColor;

    public SwitchButton(GuiFocusable screen, int x, int y, boolean checked) {
        this(screen, x, y, checked, EnumNetworkColor.BLUE.getRGB());
    }

    public SwitchButton(GuiFocusable screen, int x, int y, boolean checked, int color) {
        super(screen, x, y, 16, 8);
        if (checked) {
            this.mChecked = true;
            this.mOffset = 1.0f;
        }
        this.mColor = color;
    }

    @Override
    protected void drawButton(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        float delta = deltaTicks / 4.0f;
        this.mOffset = Mth.m_14036_((float)(this.mChecked ? this.mOffset + delta : this.mOffset - delta), (float)0.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiFocusable.ICON);
        float r = FluxUtils.getRed(this.mColor);
        float g = FluxUtils.getGreen(this.mColor);
        float b = FluxUtils.getBlue(this.mColor);
        float thumbOffset = this.mOffset * (float)this.height;
        if (this.mClickable) {
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)0.9f);
        } else {
            RenderSystem.m_157429_((float)(r * 0.5f), (float)(g * 0.5f), (float)(b * 0.5f), (float)0.9f);
        }
        this.screen.blitF(poseStack, this.x, this.y, thumbOffset * 2.0f, this.height, 320.0f, 256.0f, thumbOffset * 8.0f, 32.0f);
        if (this.mClickable) {
            if (this.isMouseHovered(mouseX, mouseY)) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (this.mChecked) {
                RenderSystem.m_157429_((float)0.85f, (float)0.85f, (float)0.85f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.screen.blitF(poseStack, this.x, this.y, this.width, this.height, 256.0f, 256.0f, 64.0f, 32.0f);
        if (this.mClickable) {
            if (this.mChecked || this.isMouseHovered(mouseX, mouseY)) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
        } else {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.screen.blitF(poseStack, (float)this.x + thumbOffset, this.y, (float)this.width / 2.0f, this.height, 256.0f, 288.0f, 32.0f, 32.0f);
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
    }

    public void setColor(int color) {
        this.mColor = color;
    }
}

