/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.gateways.Gateways;
import shadows.gateways.codec.GatewayCodecs;
import shadows.gateways.entity.GatewayEntity;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.NBTAdapter;

public interface Reward
extends PlaceboCodecs.CodecProvider<Reward> {
    public static final BiMap<ResourceLocation, Codec<? extends Reward>> CODECS = HashBiMap.create();
    public static final Codec<Reward> CODEC = GatewayCodecs.mapBacked("Gateway Reward", CODECS);
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7625_", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = Reward.lootMethodHandle();

    public void generateLoot(ServerLevel var1, GatewayEntity var2, Player var3, Consumer<ItemStack> var4);

    public void appendHoverText(Consumer<Component> var1);

    public static void initSerializers() {
        Reward.register("stack", StackReward.CODEC);
        Reward.register("stack_list", StackListReward.CODEC);
        Reward.register("entity_loot", EntityLootReward.CODEC);
        Reward.register("loot_table", LootTableReward.CODEC);
        Reward.register("chanced", ChancedReward.CODEC);
        Reward.register("command", CommandReward.CODEC);
    }

    private static void register(String id, Codec<? extends Reward> codec) {
        CODECS.put((Object)Gateways.loc(id), codec);
    }

    private static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public record StackReward(ItemStack stack) implements Reward
    {
        public static Codec<StackReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.fieldOf("stack").forGetter(StackReward::stack)).apply((Applicative)inst, StackReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(this.stack.m_41777_());
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.gateways.stack", (Object[])new Object[]{this.stack.m_41613_(), this.stack.m_41786_()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record StackListReward(List<ItemStack> stacks) implements Reward
    {
        public static Codec<StackListReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.listOf().fieldOf("stacks").forGetter(StackListReward::stacks)).apply((Applicative)inst, StackListReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            this.stacks.forEach(s -> list.accept(s.m_41777_()));
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            for (ItemStack stack : this.stacks) {
                list.accept((Component)Component.m_237110_((String)"reward.gateways.stack", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_()}));
            }
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record EntityLootReward(EntityType<?> type, @Nullable CompoundTag nbt, int rolls) implements Reward
    {
        public static Codec<EntityLootReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entity").forGetter(EntityLootReward::type), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(r -> Optional.ofNullable(r.nbt)), (App)Codec.INT.fieldOf("rolls").forGetter(EntityLootReward::rolls)).apply((Applicative)inst, (type, nbt, rolls) -> new EntityLootReward((EntityType<?>)type, nbt.orElse(null), (int)rolls)));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            try {
                ArrayList items = new ArrayList();
                Entity entity = this.type.m_20615_((Level)level);
                entity.getPersistentData().m_128379_("apoth.no_pinata", true);
                for (int i = 0; i < this.rolls; ++i) {
                    if (this.nbt != null) {
                        entity.m_20258_(this.nbt);
                    }
                    entity.m_7678_(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_(), 0.0f, 0.0f);
                    entity.m_6469_(DamageSource.m_19344_((Player)summoner).m_19382_().m_19381_().m_19380_(), 1.0f);
                    entity.captureDrops(items);
                    DROP_LOOT.invoke(entity, DamageSource.m_19344_((Player)summoner), true);
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                items.stream().map(ItemEntity::m_32055_).forEach(list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.gateways.entity", (Object[])new Object[]{this.rolls, Component.m_237115_((String)this.type.m_20675_())}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record LootTableReward(ResourceLocation table, int rolls, String desc) implements Reward
    {
        public static Codec<LootTableReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(LootTableReward::table), (App)Codec.INT.fieldOf("rolls").forGetter(LootTableReward::rolls), (App)Codec.STRING.fieldOf("desc").forGetter(LootTableReward::desc)).apply((Applicative)inst, LootTableReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            LootTable realTable = level.m_7654_().m_129898_().m_79217_(this.table);
            for (int i = 0; i < this.rolls; ++i) {
                LootContext.Builder ctx = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)gate.m_20318_(1.0f)).m_78965_((long)(gate.f_19797_ + i));
                ctx.m_78963_(summoner.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)summoner).m_78972_(LootContextParams.f_81463_, (Object)summoner.m_21205_());
                realTable.m_230922_(ctx.m_78975_(LootContextParamSets.f_81411_)).forEach(list);
            }
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.gateways.loot_table", (Object[])new Object[]{this.rolls, this.desc.isEmpty() ? this.table : Component.m_237115_((String)this.desc)}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record ChancedReward(Reward reward, float chance) implements Reward
    {
        public static Codec<ChancedReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("reward").forGetter(ChancedReward::reward), (App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedReward::chance)).apply((Applicative)inst, ChancedReward::new));
        protected static final DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            if (level.f_46441_.m_188501_() < this.chance) {
                this.reward.generateLoot(level, gate, summoner, list);
            }
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            this.reward.appendHoverText(c -> list.accept((Component)Component.m_237110_((String)"reward.gateways.chance", (Object[])new Object[]{fmt.format(this.chance), c})));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record CommandReward(String command, String desc) implements Reward
    {
        public static Codec<CommandReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("command").forGetter(CommandReward::command), (App)Codec.STRING.fieldOf("desc").forGetter(CommandReward::desc)).apply((Applicative)inst, CommandReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            String realCmd = this.command.replace("<summoner>", summoner.m_36316_().getName());
            level.m_7654_().m_129892_().m_230957_(gate.m_20203_(), realCmd);
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237115_((String)this.desc));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }
}

