/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import terrails.healthoverlay.Constants;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.heart.HeartPiece;

@Mod(value="healthoverlay")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HealthOverlay {
    public static final ForgeConfigSpec CONFIG_SPEC;
    private static final String CONFIG_FILE = "healthoverlay.toml";

    public HealthOverlay() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, server) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_SPEC, CONFIG_FILE);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        HealthOverlay.setupConfig(FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE));
    }

    private static void setupConfig(Path path) {
        Constants.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().autoreload().writingMode(WritingMode.REPLACE).build();
        Constants.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        Constants.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        CONFIG_SPEC.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void configEvent(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals("healthoverlay")) {
            return;
        }
        Constants.LOGGER.debug("Loaded {} config file {}", (Object)"healthoverlay", (Object)event.getConfig().getFileName());
    }

    private static /* synthetic */ boolean lambda$static$40(ForgeConfigSpec.ConfigValue absorptionRelativeTo, Configuration.RelativeTo value) {
        absorptionRelativeTo.set((Object)value);
        absorptionRelativeTo.save();
        return true;
    }

    private static /* synthetic */ boolean lambda$static$20(ForgeConfigSpec.ConfigValue healthRelativeTo, Configuration.RelativeTo value) {
        healthRelativeTo.set((Object)value);
        healthRelativeTo.save();
        return true;
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("health");
        ForgeConfigSpec.BooleanValue healthVanilla = builder.comment("Show vanilla hearts").define("healthVanilla", true);
        Configuration.HEALTH.vanillaHearts = new ConfigOption<Boolean>((Supplier<Boolean>)healthVanilla, () -> ((ForgeConfigSpec.BooleanValue)healthVanilla).getDefault(), value -> {
            healthVanilla.set(value);
            healthVanilla.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue healthColors = builder.comment("Colors for every 10 hearts (not counting the default red)\nAll values are written as hexadecimal RGB color in '#RRGGBB' format").defineList("healthColors", (List)Lists.newArrayList((Object[])new String[]{"#F06E14", "#F5DC23", "#2DB928", "#1EAFBE", "#7346E1", "#FA7DEB", "#EB375A", "#FF8278", "#AAFFFA", "#EBEBFF"}), o -> true);
        Configuration.HEALTH.normalColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthColors.get(), false, false), () -> HeartPiece.getColorsFromConfig((List)healthColors.getDefault(), false, false), value -> {
            healthColors.set(HeartPiece.getColorList(value));
            healthColors.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue healthPoisonColors = builder.comment("Two alternating colors when poisoned\nThere can be one color in case vanilla poisoned heart is wanted").defineList("healthPoisonColors", (List)Lists.newArrayList((Object[])new String[]{"#739B00"}), o -> true);
        Configuration.HEALTH.poisonedColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthPoisonColors.get(), false, true), () -> HeartPiece.getColorsFromConfig((List)healthPoisonColors.getDefault(), false, true), value -> {
            healthPoisonColors.set(HeartPiece.getColorList(value));
            healthPoisonColors.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue healthWitherColors = builder.comment("Two alternating colors when withered\nThere can be one color in case vanilla withered heart is wanted").defineList("healthWitherColors", (List)Lists.newArrayList((Object[])new String[]{"#0F0F0F"}), o -> true);
        Configuration.HEALTH.witheredColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthWitherColors.get(), false, true), () -> HeartPiece.getColorsFromConfig((List)healthWitherColors.getDefault(), false, true), value -> {
            healthWitherColors.set(HeartPiece.getColorList(value));
            healthWitherColors.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue healthFrozenColors = builder.comment("Two alternating colors when frozen\nThere can be one color in case vanilla frozen heart is wanted").defineList("healthFrozenColors", (List)Lists.newArrayList((Object[])new String[]{"#3E70E6"}), o -> true);
        Configuration.HEALTH.frozenColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)healthFrozenColors.get(), false, true), () -> HeartPiece.getColorsFromConfig((List)healthFrozenColors.getDefault(), false, true), value -> {
            healthFrozenColors.set(HeartPiece.getColorList(value));
            healthFrozenColors.save();
            return true;
        });
        builder.push("gui");
        ForgeConfigSpec.EnumValue healthRelativeTo = builder.comment("A point coordinates should be relative to.\nThe fastest way to set these values is to use the in-game config GUI in mods list.\nNOTE: moving towards left or top from a point always requires negative coordinates!").defineEnum("healthRelativeTo", (Enum)Configuration.RelativeTo.BOTTOM_MIDDLE);
        Configuration.HEALTH.posRelativeTo = new ConfigOption<Configuration.RelativeTo>((Supplier<Configuration.RelativeTo>)healthRelativeTo, () -> ((ForgeConfigSpec.ConfigValue)healthRelativeTo).getDefault(), arg_0 -> HealthOverlay.lambda$static$20((ForgeConfigSpec.ConfigValue)healthRelativeTo, arg_0));
        ForgeConfigSpec.ConfigValue healthX = builder.define("healthPosX", (Object)-91);
        Configuration.HEALTH.posX = new ConfigOption<Integer>((Supplier<Integer>)healthX, () -> ((ForgeConfigSpec.ConfigValue)healthX).getDefault(), value -> {
            healthX.set(value);
            healthX.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue healthY = builder.define("healthPosY", (Object)-39);
        Configuration.HEALTH.posY = new ConfigOption<Integer>((Supplier<Integer>)healthY, () -> ((ForgeConfigSpec.ConfigValue)healthY).getDefault(), value -> {
            healthY.set(value);
            healthY.save();
            return true;
        });
        builder.pop(2);
        builder.push("absorption");
        ForgeConfigSpec.BooleanValue absorptionVanilla = builder.comment("Show vanilla hearts").define("absorptionVanilla", true);
        Configuration.ABSORPTION.vanillaHearts = new ConfigOption<Boolean>((Supplier<Boolean>)absorptionVanilla, () -> ((ForgeConfigSpec.BooleanValue)absorptionVanilla).getDefault(), value -> {
            absorptionVanilla.set(value);
            absorptionVanilla.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue absorptionColors = builder.comment("Colors for every 10 hearts (not counting the default yellow)\nAll values are written as hexadecimal RGB color in '#RRGGBB' format").defineList("absorptionColors", (List)Lists.newArrayList((Object[])new String[]{"#E1FA9B", "#A0FFAF", "#AAFFFA", "#AACDFF", "#D7B4FF", "#FAA5FF", "#FFB4B4", "#FFAA7D", "#D7F0FF", "#EBFFFA"}), o -> true);
        Configuration.ABSORPTION.normalColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionColors.get(), true, false), () -> HeartPiece.getColorsFromConfig((List)absorptionColors.getDefault(), true, false), value -> {
            absorptionColors.set(HeartPiece.getColorList(value));
            absorptionColors.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue absorptionPoisonColors = builder.comment("Two alternating colors when poisoned").defineList("absorptionPoisonColors", (List)Lists.newArrayList((Object[])new String[]{"#BFF230", "#7AA15A"}), o -> true);
        Configuration.ABSORPTION.poisonedColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionPoisonColors.get(), true, false), () -> HeartPiece.getColorsFromConfig((List)absorptionPoisonColors.getDefault(), true, false), value -> {
            absorptionPoisonColors.set(HeartPiece.getColorList(value));
            absorptionPoisonColors.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue absorptionWitherColors = builder.comment("Two alternating colors when withered").defineList("absorptionWitherColors", (List)Lists.newArrayList((Object[])new String[]{"#787061", "#73625C"}), o -> true);
        Configuration.ABSORPTION.witheredColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionWitherColors.get(), true, false), () -> HeartPiece.getColorsFromConfig((List)absorptionWitherColors.getDefault(), true, false), value -> {
            absorptionWitherColors.set(HeartPiece.getColorList(value));
            absorptionWitherColors.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue absorptionFrozenColors = builder.comment("Two alternating colors when freezing").defineList("absorptionFrozenColors", (List)Lists.newArrayList((Object[])new String[]{"#90D136", "#36D183"}), o -> true);
        Configuration.ABSORPTION.frozenColors = new ConfigOption<List>(() -> HeartPiece.getColorsFromConfig((List)absorptionFrozenColors.get(), true, false), () -> HeartPiece.getColorsFromConfig((List)absorptionFrozenColors.getDefault(), true, false), value -> {
            absorptionFrozenColors.set(HeartPiece.getColorList(value));
            absorptionFrozenColors.save();
            return true;
        });
        builder.push("gui");
        ForgeConfigSpec.EnumValue absorptionRelativeTo = builder.comment("A point coordinates should be relative to.\nThe fastest way to set these values is to use the in-game config GUI in mods list.\nNOTE: moving towards left or top from a point always requires negative coordinates!").defineEnum("absorptionRelativeTo", (Enum)Configuration.RelativeTo.BOTTOM_MIDDLE);
        Configuration.ABSORPTION.posRelativeTo = new ConfigOption<Configuration.RelativeTo>((Supplier<Configuration.RelativeTo>)absorptionRelativeTo, () -> ((ForgeConfigSpec.ConfigValue)absorptionRelativeTo).getDefault(), arg_0 -> HealthOverlay.lambda$static$40((ForgeConfigSpec.ConfigValue)absorptionRelativeTo, arg_0));
        ForgeConfigSpec.ConfigValue absorptionX = builder.define("absorptionPosX", (Object)-91);
        Configuration.ABSORPTION.posX = new ConfigOption<Integer>((Supplier<Integer>)absorptionX, () -> ((ForgeConfigSpec.ConfigValue)absorptionX).getDefault(), value -> {
            absorptionX.set(value);
            absorptionX.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue absorptionY = builder.define("absorptionPosY", (Object)-49);
        Configuration.ABSORPTION.posY = new ConfigOption<Integer>((Supplier<Integer>)absorptionY, () -> ((ForgeConfigSpec.ConfigValue)absorptionY).getDefault(), value -> {
            absorptionY.set(value);
            absorptionY.save();
            return true;
        });
        builder.pop(2);
        builder.push("qol");
        ForgeConfigSpec.BooleanValue absorptionOverHealth = builder.comment("Display absorption in the same row as health\nAbsorption hearts start directly after the last health heart.").define("absorptionOverHealth", false);
        Configuration.ABSORPTION.renderOverHealth = new ConfigOption<Boolean>((Supplier<Boolean>)absorptionOverHealth, () -> ((ForgeConfigSpec.BooleanValue)absorptionOverHealth).getDefault(), value -> {
            absorptionOverHealth.set(value);
            absorptionOverHealth.save();
            return true;
        });
        builder.push("counter");
        ForgeConfigSpec.EnumValue heartDisplayMode = builder.comment("Visualizes health/absorption to left of the hearts.").defineEnum("displayMode", (Enum)Configuration.HeartDisplayMode.OFF);
        Configuration.COMMON.displayMode = new ConfigOption<Configuration.HeartDisplayMode>((Supplier<Configuration.HeartDisplayMode>)heartDisplayMode, () -> ((ForgeConfigSpec.EnumValue)heartDisplayMode).getDefault(), value -> {
            heartDisplayMode.set((Object)value);
            heartDisplayMode.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue heartStringHealth = builder.comment("Text displayed next to health. Minecraft chat color codes are allowed.\nAvailable variables:\n    \"[HEALTH]\": Current health.\n    \"[MAX]\": Max health.\n    \"[HEARTS]\": Current health in hearts.\n    \"[MAX_HEARTS]\": Max health in hearts.\n    \"[ROW]\": Current health row.\n    \"[MAX_ROW]\": Max health row.").define("textHealth", (Object)"\u00a74[HEALTH]\u00a77/\u00a72[MAX]");
        Configuration.HEALTH.displayText = new ConfigOption<String>((Supplier<String>)heartStringHealth, () -> ((ForgeConfigSpec.ConfigValue)heartStringHealth).getDefault(), value -> {
            heartStringHealth.set(value);
            heartStringHealth.save();
            return true;
        });
        ForgeConfigSpec.ConfigValue heartStringAbsorption = builder.comment("Text displayed next to absorption. Minecraft chat color codes are allowed.\nIn case 'absorptionOverHealth' is true, this text is displayed at the same position as or left of 'textHealth'.\nAvailable variables:\n    \"[ABSORPTION]\": Current absorption.\n    \"[HEARTS]\": Current absorption in hearts.\n    \"[ROW]\": Current absorption row.").define("textAbsorption", (Object)"\u00a76[ABSORPTION]");
        Configuration.ABSORPTION.displayText = new ConfigOption<String>((Supplier<String>)heartStringAbsorption, () -> ((ForgeConfigSpec.ConfigValue)heartStringAbsorption).getDefault(), value -> {
            heartStringAbsorption.set(value);
            heartStringAbsorption.save();
            return true;
        });
        builder.pop(2);
        CONFIG_SPEC = builder.build();
    }
}

