/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public abstract class IERecipeSerializer<R extends Recipe<?>>
implements RecipeSerializer<R> {
    public abstract ItemStack getIcon();

    public R fromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        if (CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)context)) {
            return this.readFromJson(recipeId, json, context);
        }
        return null;
    }

    public R m_6729_(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject serializedRecipe) {
        return null;
    }

    protected static Lazy<ItemStack> readOutput(JsonElement outputObject) {
        if (outputObject.isJsonObject() && outputObject.getAsJsonObject().has("item")) {
            return Lazy.of(() -> ShapedRecipe.m_151274_((JsonObject)outputObject.getAsJsonObject()));
        }
        IngredientWithSize outgredient = IngredientWithSize.deserialize(outputObject);
        return Lazy.of(() -> IEApi.getPreferredStackbyMod(outgredient.getMatchingStacks()));
    }

    @Nullable
    protected static StackWithChance readConditionalStackWithChance(JsonElement element, ICondition.IContext context) {
        JsonObject object = element.getAsJsonObject();
        if (CraftingHelper.processConditions((JsonObject)object, (String)"conditions", (ICondition.IContext)context)) {
            float chance = GsonHelper.m_13915_((JsonObject)object, (String)"chance");
            Lazy<ItemStack> stack = IERecipeSerializer.readOutput(object.get("output"));
            return new StackWithChance(stack, chance);
        }
        return null;
    }

    public abstract R readFromJson(ResourceLocation var1, JsonObject var2, ICondition.IContext var3);

    protected static Lazy<ItemStack> readLazyStack(FriendlyByteBuf buf) {
        ItemStack stack = buf.m_130267_();
        return Lazy.of(() -> stack);
    }

    protected static void writeLazyStack(FriendlyByteBuf buf, Lazy<ItemStack> stack) {
        buf.m_130055_((ItemStack)stack.get());
    }
}

