/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.utils.FastEither;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class WindmillBiome
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<WindmillBiome>> SERIALIZER;
    public static final CachedRecipeList<WindmillBiome> ALL_BIOMES;
    public final FastEither<TagKey<Biome>, List<Biome>> biomes;
    public final float modifier;

    public WindmillBiome(ResourceLocation id, TagKey<Biome> biomes, float modifier) {
        this(id, FastEither.left(biomes), modifier);
    }

    public WindmillBiome(ResourceLocation id, List<Biome> biomes, float modifier) {
        this(id, FastEither.right(biomes), modifier);
    }

    private WindmillBiome(ResourceLocation id, FastEither<TagKey<Biome>, List<Biome>> biomes, float modifier) {
        super((Lazy<ItemStack>)LAZY_EMPTY, IERecipeTypes.WINDMILL_BIOME, id);
        this.biomes = biomes;
        this.modifier = modifier;
    }

    @Override
    protected IERecipeSerializer<?> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public float getModifier() {
        return this.modifier;
    }

    public boolean matches(Holder<Biome> biome) {
        if (this.biomes.isLeft()) {
            return biome.m_203656_(this.biomes.leftNonnull());
        }
        return this.biomes.rightNonnull().contains(biome.m_203334_());
    }

    @Nullable
    public static WindmillBiome getBiome(Level level, Holder<Biome> biome, @Nullable WindmillBiome hint) {
        if (hint != null && hint.matches(biome)) {
            return hint;
        }
        for (WindmillBiome entry : ALL_BIOMES.getRecipes(level)) {
            if (!entry.matches(biome)) continue;
            return entry;
        }
        return null;
    }

    static {
        ALL_BIOMES = new CachedRecipeList<WindmillBiome>(IERecipeTypes.WINDMILL_BIOME);
    }
}

