/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.gui.RevolverContainer;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class RevolverScreen
extends IEContainerScreen<RevolverContainer> {
    private static final ResourceLocation TEXTURE = RevolverScreen.makeTextureLocation("revolver");
    private final int[] bullets = new int[2];
    private final boolean otherRevolver;
    private final int offset;

    public RevolverScreen(RevolverContainer container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        ItemStack revolver = inventoryPlayer.f_35978_.m_6844_(container.entityEquipmentSlot);
        if (!revolver.m_41619_() && revolver.m_41720_() instanceof IEItemInterfaces.IBulletContainer) {
            this.bullets[0] = ((IEItemInterfaces.IBulletContainer)revolver.m_41720_()).getBulletCount(revolver);
        }
        boolean bl = this.otherRevolver = !((RevolverContainer)this.f_97732_).secondRevolver.m_41619_();
        if (this.otherRevolver) {
            this.bullets[1] = ((IEItemInterfaces.IBulletContainer)((RevolverContainer)this.f_97732_).secondRevolver.m_41720_()).getBulletCount(((RevolverContainer)this.f_97732_).secondRevolver);
            this.offset = ((this.bullets[0] >= 18 ? 150 : (this.bullets[0] > 8 ? 136 : 74)) + (this.bullets[1] >= 18 ? 150 : (this.bullets[1] > 8 ? 136 : 74)) + 4 - 176) / 2;
            if (this.offset > 0) {
                this.f_97726_ += this.offset * 2;
            }
        } else {
            this.offset = ((this.bullets[0] >= 18 ? 150 : (this.bullets[0] > 8 ? 136 : 74)) - 176) / 2;
        }
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull PoseStack transform, float par1, int par2, int par3) {
        int off = this.offset < 0 ? -this.offset : 0;
        for (int hand = 0; hand < (this.otherRevolver ? 2 : 1); ++hand) {
            int side = !this.otherRevolver ? 0 : (hand == 0 == (ImmersiveEngineering.proxy.getClientPlayer().m_5737_() == HumanoidArm.RIGHT) ? 1 : 0);
            this.m_93228_(transform, this.f_97735_ + off + 0, this.f_97736_ + 1, 0, 51, 74, 74);
            if (this.bullets[side] >= 18) {
                this.m_93228_(transform, this.f_97735_ + off + 47, this.f_97736_ + 1, 74, 51, 103, 74);
            } else if (this.bullets[side] > 8) {
                this.m_93228_(transform, this.f_97735_ + off + 57, this.f_97736_ + 1, 57, 12, 79, 39);
            }
            off += (this.bullets[side] >= 18 ? 150 : (this.bullets[side] > 8 ? 136 : 74)) + 4;
        }
    }

    @Override
    protected void drawBackgroundTexture(PoseStack transform) {
        this.m_93228_(transform, this.f_97735_ + Math.max(this.offset, 0), this.f_97736_ + 77, 0, 125, 176, 89);
    }

    public static void drawExternalGUI(NonNullList<ItemStack> bullets, int bulletAmount, PoseStack transform) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer builder = buffer.m_6299_(IERenderTypes.getGui(TEXTURE));
        GuiHelper.drawTexturedColoredRect(builder, transform, 0.0f, 1.0f, 74.0f, 74.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.2890625f, 0.19921875f, 0.48828125f);
        if (bulletAmount >= 18) {
            GuiHelper.drawTexturedColoredRect(builder, transform, 47.0f, 1.0f, 103.0f, 74.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.2890625f, 0.69140625f, 0.19921875f, 0.48828125f);
        } else if (bulletAmount > 8) {
            GuiHelper.drawTexturedColoredRect(builder, transform, 57.0f, 1.0f, 79.0f, 39.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.22265625f, 0.53125f, 0.046875f, 0.19921875f);
        }
        buffer.m_109911_();
        ItemRenderer ir = ClientUtils.mc().m_91291_();
        int[][] slots = RevolverContainer.slotPositions[bulletAmount >= 18 ? 2 : (bulletAmount > 8 ? 1 : 0)];
        PoseStack modelviewStack = RenderSystem.m_157191_();
        modelviewStack.m_85836_();
        if (modelviewStack != transform) {
            modelviewStack.m_166854_(transform.m_85850_().m_85861_());
        }
        modelviewStack.m_85837_(0.0, 0.0, 10.0);
        RenderSystem.m_157182_();
        for (int i = 0; i < bulletAmount; ++i) {
            int y;
            int x;
            ItemStack b = (ItemStack)bullets.get(i);
            if (b.m_41619_()) continue;
            if (i == 0) {
                x = 29;
                y = 3;
            } else if (i - 1 < slots.length) {
                x = slots[i - 1][0];
                y = slots[i - 1][1];
            } else {
                int ii = i - (slots.length + 1);
                int n = ii == 0 ? 48 : (ii == 1 ? 29 : (x = ii == 3 ? 2 : 10));
                y = ii == 1 ? 57 : (ii == 3 ? 30 : (ii == 4 ? 11 : 49));
            }
            ir.m_115203_(b, x, y);
        }
        modelviewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

