/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.info;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class FluidInfoArea
extends InfoArea {
    private final IFluidTank tank;
    private final Rect2i area;
    private final int overlayUMin;
    private final int overlayVMin;
    private final int overlayWidth;
    private final int overlayHeight;
    private final ResourceLocation overlayTexture;

    public FluidInfoArea(IFluidTank tank, Rect2i area, int overlayUMin, int overlayVMin, int overlayWidth, int overlayHeight, ResourceLocation overlayTexture) {
        super(area);
        this.tank = tank;
        this.area = area;
        this.overlayUMin = overlayUMin;
        this.overlayVMin = overlayVMin;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
        this.overlayTexture = overlayTexture;
    }

    @Override
    public void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        FluidInfoArea.fillTooltip(this.tank.getFluid(), this.tank.getCapacity(), tooltip::add);
    }

    public static void fillTooltip(FluidStack fluid, int tankCapacity, Consumer<Component> tooltip) {
        if (!fluid.isEmpty()) {
            tooltip.accept((Component)TextUtils.applyFormat(fluid.getDisplayName(), fluid.getFluid().getFluidType().getRarity((FluidStack)fluid).f_43022_));
        } else {
            tooltip.accept((Component)Component.m_237115_((String)"gui.immersiveengineering.empty"));
        }
        Fluid fluid2 = fluid.getFluid();
        if (fluid2 instanceof PotionFluid) {
            PotionFluid potion = (PotionFluid)fluid2;
            potion.addInformation(fluid, tooltip);
        }
        if (ClientUtils.mc().f_91066_.f_92125_ && !fluid.isEmpty()) {
            if (!Screen.m_96638_()) {
                tooltip.accept((Component)Component.m_237115_((String)"desc.immersiveengineering.info.holdShiftForInfo"));
            } else {
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Fluid Registry: " + Registry.f_122822_.m_7981_((Object)fluid.getFluid()))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Density: " + fluid.getFluid().getFluidType().getDensity(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Temperature: " + fluid.getFluid().getFluidType().getTemperature(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("Viscosity: " + fluid.getFluid().getFluidType().getViscosity(fluid))), ChatFormatting.DARK_GRAY));
                tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)("NBT Data: " + fluid.getTag())), ChatFormatting.DARK_GRAY));
            }
        }
        if (tankCapacity > 0) {
            tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)(fluid.getAmount() + "/" + tankCapacity + "mB")), ChatFormatting.GRAY));
        } else if (tankCapacity == 0) {
            tooltip.accept((Component)TextUtils.applyFormat((Component)Component.m_237113_((String)(fluid.getAmount() + "mB")), ChatFormatting.GRAY));
        }
    }

    @Override
    public void draw(PoseStack transform) {
        FluidStack fluid = this.tank.getFluid();
        float capacity = this.tank.getCapacity();
        transform.m_85836_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (!fluid.isEmpty()) {
            int fluidHeight = (int)((float)this.area.m_110091_() * ((float)fluid.getAmount() / capacity));
            GuiHelper.drawRepeatedFluidSpriteGui((MultiBufferSource)buffer, transform, fluid, this.area.m_110085_(), this.area.m_110086_() + this.area.m_110091_() - fluidHeight, this.area.m_110090_(), fluidHeight);
        }
        int xOff = (this.area.m_110090_() - this.overlayWidth) / 2;
        int yOff = (this.area.m_110091_() - this.overlayHeight) / 2;
        RenderType renderType = IERenderTypes.getGui(this.overlayTexture);
        GuiHelper.drawTexturedRect(buffer.m_6299_(renderType), transform, this.area.m_110085_() + xOff, this.area.m_110086_() + yOff, this.overlayWidth, this.overlayHeight, 256.0f, this.overlayUMin, this.overlayUMin + this.overlayWidth, this.overlayVMin, this.overlayVMin + this.overlayHeight);
        buffer.m_109911_();
        transform.m_85849_();
    }
}

