/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.common.entities.illager.Fusilier;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RailgunCallbacks
implements ItemCallback<Key> {
    public static RailgunCallbacks INSTANCE = new RailgunCallbacks();

    @Override
    public Key extractKey(ItemStack stack, LivingEntity owner) {
        CompoundTag upgrades = RailgunItem.getUpgradesStatic(stack);
        return new Key(upgrades.m_128471_("scope"), upgrades.m_128459_("speed") > 0.0);
    }

    @Override
    public boolean shouldRenderGroup(Key stack, String group, RenderType layer) {
        if (group.equals("upgrade_scope")) {
            return stack.scope();
        }
        if (group.equals("upgrade_speed")) {
            return stack.speed();
        }
        if (group.equals("barrel_top")) {
            return !stack.speed();
        }
        return true;
    }

    @Override
    public void handlePerspective(Key key, LivingEntity holder, ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        if (holder instanceof Fusilier) {
            Fusilier fusilier = (Fusilier)holder;
            if (cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
                switch (fusilier.m_6768_()) {
                    case CROSSBOW_HOLD: {
                        mat.m_85845_(new Quaternion(-10.0f, -15.0f, -40.0f, true));
                        mat.m_85837_(0.5, -2.5, 0.75);
                        break;
                    }
                    case CELEBRATING: {
                        mat.m_85837_(-4.5, -4.0, 2.0);
                        mat.m_85845_(Vector3f.f_122225_.m_122240_(-95.0f));
                        mat.m_85845_(Vector3f.f_122227_.m_122240_(-50.0f));
                        mat.m_85845_(Vector3f.f_122223_.m_122240_(20.0f));
                        break;
                    }
                    default: {
                        mat.m_85845_(new Quaternion(-8.0f, 0.0f, 110.0f, true));
                        mat.m_85837_(4.75, 4.0, 0.0);
                    }
                }
            }
        }
    }

    public record Key(boolean scope, boolean speed) {
    }
}

