/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PostBlock
extends IEBaseBlock
implements IPostBlock,
IModelOffsetProvider {
    public static final IntegerProperty POST_SLAVE = IntegerProperty.m_61631_((String)"post_slave", (int)0, (int)3);
    public static final EnumProperty<HorizontalOffset> HORIZONTAL_OFFSET = EnumProperty.m_61587_((String)"horizontal_offset", HorizontalOffset.class);
    private static final ThreadLocal<Boolean> recursionLock = new ThreadLocal();

    public PostBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps);
        this.setMobility(PushReaction.BLOCK);
        this.lightOpacity = 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POST_SLAVE, HORIZONTAL_OFFSET, BlockStateProperties.f_61362_});
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return ImmutableList.of();
    }

    public void m_6810_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, BlockState newState, boolean moving) {
        if (state.m_60734_() != newState.m_60734_()) {
            int dummyState = (Integer)state.m_61143_((Property)POST_SLAVE);
            HorizontalOffset offset = (HorizontalOffset)((Object)state.m_61143_(HORIZONTAL_OFFSET));
            if (dummyState > 0 && offset == HorizontalOffset.NONE) {
                world.m_46597_(pos.m_6625_(dummyState), Blocks.f_50016_.m_49966_());
            } else if (dummyState == 0) {
                PostBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
                int highestBlock = 3;
                BlockPos armStart = pos.m_6630_(3);
                for (Direction d : DirectionUtils.BY_HORIZONTAL_INDEX) {
                    BlockPos armPos = armStart.m_121945_(d);
                    BlockState armState = world.m_8055_(armPos);
                    if (armState.m_60734_() != this || !((HorizontalOffset)((Object)armState.m_61143_(HORIZONTAL_OFFSET))).getOffset().equals((Object)d.m_122436_())) continue;
                    world.m_46597_(armPos, Blocks.f_50016_.m_49966_());
                }
                for (int i = 0; i <= 3; ++i) {
                    world.m_46597_(pos.m_6630_(i), Blocks.f_50016_.m_49966_());
                }
            }
        }
        super.m_6810_(state, world, pos, newState, moving);
    }

    @Override
    public boolean canIEBlockBePlaced(@Nonnull BlockState newState, BlockPlaceContext context) {
        BlockPos startingPos = context.m_8083_();
        Level level = context.m_43725_();
        for (int hh = 1; hh <= 3; ++hh) {
            BlockPos pos = startingPos.m_6630_(hh);
            BlockPlaceContext dummyContext = BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)pos, (Direction)context.m_43719_());
            BlockState oldState = level.m_8055_(pos);
            if (!level.m_151570_(pos) && oldState.m_60734_().m_6864_(oldState, dummyContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (int i = 1; i <= 3; ++i) {
            BlockPos dummyPos = pos.m_6630_(i);
            world.m_46597_(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.m_61124_((Property)POST_SLAVE, (Comparable)Integer.valueOf(i)), world, dummyPos));
            world.m_7696_(pos.m_7918_(0, i, 0), (Block)this, 255, 0);
        }
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, @Nullable LivingEntity entity) {
        return true;
    }

    private static boolean hasArmFor(BlockPos center, Direction side, BlockGetter world, Block expected) {
        int highest = 3;
        BlockState centerState = world.m_8055_(center);
        if (centerState.m_60734_() != expected || (Integer)centerState.m_61143_((Property)POST_SLAVE) != 3 || centerState.m_61143_(HORIZONTAL_OFFSET) != HorizontalOffset.NONE) {
            return false;
        }
        BlockState armState = world.m_8055_(center.m_121945_(side));
        return armState.m_60734_() == expected && (Integer)armState.m_61143_((Property)POST_SLAVE) == 3 && ((HorizontalOffset)((Object)armState.m_61143_(HORIZONTAL_OFFSET))).getOffset().equals((Object)side.m_122436_());
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level world, BlockPos pos, BlockHitResult hit) {
        BlockState state = world.m_8055_(pos);
        int dummy = (Integer)state.m_61143_((Property)POST_SLAVE);
        HorizontalOffset offset = (HorizontalOffset)((Object)state.m_61143_(HORIZONTAL_OFFSET));
        boolean changed = false;
        if (dummy == 3 && offset == HorizontalOffset.NONE && side.m_122434_() != Direction.Axis.Y) {
            BlockPos offsetPos = pos.m_121945_(side);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, hand, hit));
            if (!world.m_8055_(offsetPos).m_60629_(context)) {
                return InteractionResult.FAIL;
            }
            for (Direction forbidden : ImmutableList.of((Object)side.m_122427_(), (Object)side.m_122428_())) {
                if (!PostBlock.hasArmFor(pos, forbidden, (BlockGetter)world, this)) continue;
                return InteractionResult.FAIL;
            }
            BlockState arm_state = (BlockState)((BlockState)this.m_5573_(context).m_61124_((Property)POST_SLAVE, (Comparable)Integer.valueOf(3))).m_61124_(HORIZONTAL_OFFSET, (Comparable)((Object)HorizontalOffset.get(side)));
            world.m_46597_(offsetPos, arm_state);
            changed = true;
        } else if (dummy == 3 && offset != HorizontalOffset.NONE) {
            world.m_7471_(pos, false);
            changed = true;
        }
        if (changed) {
            BlockPos masterPos = pos.m_6625_(dummy).m_121996_(offset.getOffset());
            BlockState masterState = world.m_8055_(masterPos);
            world.m_7260_(masterPos, masterState, masterState, 3);
            return InteractionResult.SUCCESS;
        }
        return super.hammerUseSide(side, player, hand, world, pos, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83148_((VoxelShape)this.getMainShape(state, worldIn, pos), (VoxelShape)this.getConnectionShapes(state, worldIn, pos), (BooleanOp)BooleanOp.f_82695_);
    }

    private VoxelShape getMainShape(BlockState state, BlockGetter world, BlockPos pos) {
        int dummy = (Integer)state.m_61143_((Property)POST_SLAVE);
        if (dummy == 0) {
            return Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
        }
        if (dummy <= 2) {
            return Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
        }
        if (dummy == 3) {
            float down = PostBlock.hasConnection(state, Direction.DOWN, world, pos) ? 0.0f : 0.4375f;
            float up = down > 0.0f ? 1.0f : 0.5625f;
            return switch ((HorizontalOffset)((Object)state.m_61143_(HORIZONTAL_OFFSET))) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalOffset.NONE -> Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
                case HorizontalOffset.NORTH -> Shapes.m_83048_((double)0.3125, (double)down, (double)0.3125, (double)0.6875, (double)up, (double)1.0);
                case HorizontalOffset.SOUTH -> Shapes.m_83048_((double)0.3125, (double)down, (double)0.0, (double)0.6875, (double)up, (double)0.6875);
                case HorizontalOffset.EAST -> Shapes.m_83048_((double)0.0, (double)down, (double)0.3125, (double)0.6875, (double)up, (double)0.6875);
                case HorizontalOffset.WEST -> Shapes.m_83048_((double)0.3125, (double)down, (double)0.3125, (double)1.0, (double)up, (double)0.6875);
            };
        }
        return Shapes.m_83144_();
    }

    private VoxelShape getConnectionShapes(BlockState state, BlockGetter world, BlockPos pos) {
        HorizontalOffset offset = (HorizontalOffset)((Object)state.m_61143_(HORIZONTAL_OFFSET));
        if (offset == HorizontalOffset.NONE) {
            int dummy = (Integer)state.m_61143_((Property)POST_SLAVE);
            if (dummy == 0) {
                return Shapes.m_83040_();
            }
            double baseWidth = dummy == 3 ? 0.375 : 0.25;
            VoxelShape ret = Shapes.m_83040_();
            for (Direction neighbor : DirectionUtils.BY_HORIZONTAL_INDEX) {
                double maxY;
                double minY;
                if (!PostBlock.hasConnection(state, neighbor, world, pos)) continue;
                if (dummy < 3) {
                    minY = 0.25;
                    maxY = 0.8125;
                } else {
                    BlockPos neighborPos = pos.m_121945_(neighbor);
                    BlockState neighborState = world.m_8055_(neighborPos);
                    if (PostBlock.hasConnection(neighborState, Direction.DOWN, world, neighborPos)) {
                        minY = 0.0;
                        maxY = 0.5625;
                    } else {
                        minY = 0.4375;
                        maxY = 1.0;
                    }
                }
                double[] horizontalBounds = new double[]{(1.0 - baseWidth) / 2.0, (1.0 + baseWidth) / 2.0, (1.0 - baseWidth) / 2.0, (1.0 + baseWidth) / 2.0};
                int minIndex = neighbor.m_122434_() == Direction.Axis.X ? 0 : 2;
                int maxIndex = minIndex + 1;
                if (neighbor.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    horizontalBounds[minIndex] = horizontalBounds[maxIndex];
                    horizontalBounds[maxIndex] = 1.0;
                } else {
                    horizontalBounds[maxIndex] = horizontalBounds[minIndex];
                    horizontalBounds[minIndex] = 0.0;
                }
                VoxelShape sideShape = Shapes.m_83048_((double)horizontalBounds[0], (double)minY, (double)horizontalBounds[2], (double)horizontalBounds[1], (double)maxY, (double)horizontalBounds[3]);
                ret = Shapes.m_83148_((VoxelShape)ret, (VoxelShape)sideShape, (BooleanOp)BooleanOp.f_82695_);
            }
            return ret;
        }
        return Shapes.m_83040_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasConnection(BlockState stateHere, Direction dir, BlockGetter world, BlockPos pos) {
        if (recursionLock.get() != null && recursionLock.get().booleanValue()) {
            return true;
        }
        recursionLock.set(true);
        try {
            boolean bl = PostBlock.hasConnectionInner(stateHere, dir, world, pos);
            return bl;
        }
        finally {
            recursionLock.set(false);
        }
    }

    private static boolean hasConnectionInner(BlockState stateHere, Direction dir, BlockGetter world, BlockPos pos) {
        BlockPos neighborPos = pos.m_121945_(dir);
        int dummy = (Integer)stateHere.m_61143_((Property)POST_SLAVE);
        boolean ret = false;
        if (dummy > 0 && dummy < 3) {
            BlockState neighborState = world.m_8055_(neighborPos);
            VoxelShape shape = neighborState.m_60808_(world, neighborPos);
            if (!shape.m_83281_()) {
                boolean connect;
                AABB aabb = shape.m_83215_();
                double distance = dir == Direction.NORTH ? aabb.f_82293_ - 1.0 : (dir == Direction.SOUTH ? aabb.f_82290_ : (dir == Direction.WEST ? aabb.f_82291_ - 1.0 : aabb.f_82288_));
                double eps = 1.0E-7;
                boolean bl = connect = distance < 1.0E-7 && distance > -1.0E-7;
                if (connect) {
                    ret = dir.m_122434_() == Direction.Axis.Z ? aabb.f_82288_ > 1.0E-7 && aabb.f_82291_ < 0.9999999 : aabb.f_82290_ > 1.0E-7 && aabb.f_82293_ < 0.9999999;
                }
            }
        } else if (dummy == 3) {
            HorizontalOffset offset = (HorizontalOffset)((Object)stateHere.m_61143_(HORIZONTAL_OFFSET));
            if (offset == HorizontalOffset.NONE) {
                ret = PostBlock.hasArmFor(pos, dir, world, stateHere.m_60734_());
            } else if (world.m_8055_(neighborPos).m_60795_() || dir.m_122434_() != Direction.Axis.Y) {
                ret = false;
            } else {
                BlockState neighborState = world.m_8055_(neighborPos);
                if (neighborState.m_60767_().m_76336_()) {
                    ret = false;
                } else {
                    VoxelShape shape = neighborState.m_60808_(world, neighborPos);
                    ret = PostBlock.shapeReachesBlockFace(shape, dir.m_122424_());
                }
            }
        }
        return ret;
    }

    private static boolean shapeReachesBlockFace(VoxelShape shape, Direction face) {
        if (face.m_122421_() == Direction.AxisDirection.POSITIVE) {
            return shape.m_83297_(face.m_122434_()) == 1.0;
        }
        return shape.m_83288_(face.m_122434_()) == 0.0;
    }

    @Override
    public boolean canConnectTransformer(BlockGetter world, BlockPos pos) {
        int offset = (Integer)world.m_8055_(pos).m_61143_((Property)POST_SLAVE);
        return offset > 0;
    }

    @Override
    @Nonnull
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        HorizontalOffset d = (HorizontalOffset)((Object)state.m_61143_(HORIZONTAL_OFFSET));
        return new BlockPos(0, ((Integer)state.m_61143_((Property)POST_SLAVE)).intValue(), 0).m_121955_(d.getOffset());
    }

    @Override
    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public static enum HorizontalOffset implements StringRepresentable
    {
        NONE,
        NORTH,
        SOUTH,
        EAST,
        WEST;


        public static HorizontalOffset get(Direction side) {
            return switch (side) {
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.WEST -> WEST;
                case Direction.EAST -> EAST;
                default -> throw new IllegalArgumentException("No horizontal offset for " + side.name());
            };
        }

        public Vec3i getOffset() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORTH -> Direction.NORTH.m_122436_();
                case SOUTH -> Direction.SOUTH.m_122436_();
                case EAST -> Direction.EAST.m_122436_();
                case WEST -> Direction.WEST.m_122436_();
                case NONE -> BlockPos.f_121853_;
            };
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

