/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.client.fx.FluidSplashOptions;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class MixerBlockEntity
extends PoweredMultiblockBlockEntity<MixerBlockEntity, MixerRecipe>
implements IEBlockInterfaces.IInteractionObjectIE<MixerBlockEntity>,
IEBlockInterfaces.IBlockBounds,
IEClientTickableBE,
IEBlockInterfaces.ISoundBE {
    public static final int NUM_SLOTS = 8;
    public static final int ENERGY_CAPACITY = 16000;
    public static final int TANK_VOLUME = 8000;
    public final MultiFluidTank tank = new MultiFluidTank(8000);
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    public float animation_agitator = 0.0f;
    public boolean outputAll;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(MixerBlockEntity::getShape);
    private CapabilityReference<IItemHandler> outputCap = CapabilityReference.forBlockEntityAt(this, this::getOutputPos, ForgeCapabilities.ITEM_HANDLER);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8])));
    private final MultiblockCapability<IFluidHandler> fluidInputCap = MultiblockCapability.make(this, be -> be.fluidInputCap, MultiblockPartBlockEntity::master, this.registerFluidInput(this.tank));
    private final MultiblockCapability<IFluidHandler> fluidOutputCap = MultiblockCapability.make(this, be -> be.fluidOutputCap, MultiblockPartBlockEntity::master, this.registerFluidOutput(this.tank));
    private static final PoweredMultiblockBlockEntity.MultiblockFace FLUID_OUTPUT = new PoweredMultiblockBlockEntity.MultiblockFace(1, 0, 2, RelativeBlockFace.FRONT);
    private static final PoweredMultiblockBlockEntity.MultiblockFace FLUID_INPUT = new PoweredMultiblockBlockEntity.MultiblockFace(0, 0, 1, RelativeBlockFace.LEFT);

    public MixerBlockEntity(BlockEntityType<MixerBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.MIXER, 16000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        if (!descPacket) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
        this.outputAll = nbt.m_128471_("outputAll");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
        nbt.m_128365_("tank", (Tag)tankTag);
        if (!descPacket) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
        nbt.m_128379_("outputAll", this.outputAll);
    }

    @Override
    public boolean canTickAny() {
        return super.canTickAny() && !this.isRSDisabled();
    }

    @Override
    public void tickClient() {
        if (this.shouldRenderAsActive()) {
            if (!this.tank.fluids.isEmpty()) {
                FluidStack fs = this.tank.fluids.get(0);
                float amount = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 1.125f;
                Vec3 partPos = new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f + (float)this.getFacing().m_122429_() * 0.5f + (float)(this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_()).m_122429_() * 0.5f), (double)((float)this.m_58899_().m_123342_() - 0.0625f + amount), (double)((float)this.m_58899_().m_123343_() + 0.5f + (float)this.getFacing().m_122431_() * 0.5f + (float)(this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_()).m_122431_() * 0.5f));
                float r = ApiUtils.RANDOM.nextFloat() * 0.8125f;
                float angleRad = (float)Math.toRadians(this.animation_agitator);
                partPos = partPos.m_82520_((double)r * Math.cos(angleRad), 0.0, (double)r * Math.sin(angleRad));
                if (ApiUtils.RANDOM.nextBoolean()) {
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.IE_BUBBLE.get(), partPos.f_82479_, partPos.f_82480_ - 0.25, partPos.f_82481_, 0.0, 0.0, 0.0);
                    this.f_58857_.m_7107_((ParticleOptions)IEParticles.IE_BUBBLE.get(), partPos.f_82479_, partPos.f_82480_ - 0.25, partPos.f_82481_, 0.0, 0.0, 0.0);
                } else {
                    this.f_58857_.m_7107_((ParticleOptions)new FluidSplashOptions(fs.getFluid()), partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, 0.0, 0.0, 0.0);
                    this.f_58857_.m_7107_((ParticleOptions)new FluidSplashOptions(fs.getFluid()), partPos.f_82479_, partPos.f_82480_, partPos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            this.animation_agitator = (this.animation_agitator + 9.0f) % 360.0f;
            ImmersiveEngineering.proxy.handleTileSound((Supplier<SoundEvent>)IESounds.mixer, this, this.shouldRenderAsActive(), 0.075f, 1.0f);
        }
    }

    @Override
    public void tickServer() {
        int fluidTypes;
        int tankAmount;
        super.tickServer();
        boolean update = false;
        boolean foundRecipe = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && (tankAmount = this.tank.getFluidAmount()) > 0) {
            HashSet<Integer> usedInvSlots = new HashSet<Integer>();
            for (MultiblockProcess process : this.processQueue) {
                if (!(process instanceof MultiblockProcessInMachine)) continue;
                for (int i : ((MultiblockProcessInMachine)process).getInputSlots()) {
                    usedInvSlots.add(i);
                }
            }
            NonNullList components = NonNullList.m_122780_((int)this.inventory.size(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < components.size(); ++i) {
                if (usedInvSlots.contains(i)) continue;
                components.set(i, (Object)((ItemStack)this.inventory.get(i)));
            }
            for (FluidStack fs : this.tank.fluids) {
                MixerRecipe recipe = MixerRecipe.findRecipe(this.f_58857_, fs, (NonNullList<ItemStack>)components);
                if (recipe == null) continue;
                foundRecipe = true;
                MultiblockProcessInMachine process = new MultiblockProcessMixer(recipe, this::getRecipeForId, recipe.getUsedSlots(fs, (NonNullList<ItemStack>)components)).setInputTanks(0);
                if (!this.addProcessToQueue(process, true)) continue;
                this.addProcessToQueue(process, false);
                update = true;
            }
        }
        if ((fluidTypes = this.tank.getFluidTypes()) > 0 && (fluidTypes > 1 || !foundRecipe || this.outputAll)) {
            BlockPos outputPos = this.m_58899_().m_7495_().m_5484_(this.getFacing().m_122424_(), 2);
            update |= FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)outputPos, (Direction)this.getFacing()).map(output -> {
                boolean ret;
                block3: {
                    block2: {
                        ret = false;
                        if (this.outputAll) break block2;
                        FluidStack inTank = this.tank.getFluid();
                        FluidStack out = Utils.copyFluidStackWithAmount(inTank, Math.min(inTank.getAmount(), 1000), false);
                        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) break block3;
                        int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                        this.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                        ret = true;
                        break block3;
                    }
                    int totalOut = 0;
                    Iterator<FluidStack> it = this.tank.fluids.iterator();
                    while (it.hasNext()) {
                        FluidStack fs = it.next();
                        if (fs == null) continue;
                        FluidStack out = Utils.copyFluidStackWithAmount(fs, Math.min(fs.getAmount(), 1000 - totalOut), false);
                        int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted > 0) {
                            int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                            MultiFluidTank.drain(drained, fs, it, IFluidHandler.FluidAction.EXECUTE);
                            totalOut += drained;
                            ret = true;
                        }
                        if (totalOut < 1000) continue;
                        break;
                    }
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(2, 0, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875), (Object)new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
        }
        if (posInMultiblock.m_123341_() > 0 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123343_() < 2) {
            List<AABB> list = Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 2, new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.0625, 0.5, 0.6875, 0.3125, 1.0, 0.9375));
            if (new BlockPos(1, 0, 1).equals((Object)posInMultiblock)) {
                list.add(new AABB(0.0, 0.5, 0.375, 1.125, 0.75, 0.625));
                list.add(new AABB(0.875, 0.5, -0.125, 1.125, 0.75, 0.375));
                list.add(new AABB(0.875, 0.75, -0.125, 1.125, 1.0, 0.125));
            }
            return list;
        }
        if (posInMultiblock.m_123341_() > 0 && posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() < 2) {
            return Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 2, new AABB(0.1875, -0.25, 0.0, 1.0, 0.0, 0.8125), new AABB(0.0625, 0.0, 0.0, 0.1875, 1.0, 0.9375), new AABB(0.1875, 0.0, 0.8125, 1.0, 1.0, 0.9375));
        }
        if (new BlockPos(0, 2, 1).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.1875, 0.0, 0.1875, 1.0, 0.625, 0.6875));
        }
        if (new BlockPos(1, 2, 1).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.5625, 0.1875, -0.4375, 1.4375, 1.0, 0.4375), (Object)new AABB(0.0, 0.0, 0.0, 0.5625, 0.875, 0.5));
        }
        if (posInMultiblock.m_123342_() == 0 && !ImmutableSet.of((Object)new BlockPos(0, 0, 2), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(1, 0, 2)).contains((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (new BlockPos(2, 1, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(0, 1, 2, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MixerRecipe> process) {
        return true;
    }

    private DirectionalBlockPos getOutputPos() {
        return new DirectionalBlockPos(this.f_58858_.m_5484_(this.getFacing(), 2), this.getFacing());
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).m_41619_()) {
            Utils.dropStackAtPos(this.f_58857_, this.getOutputPos(), output);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MixerRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MixerRecipe> process) {
        return 0.0f;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    @Nonnull
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[]{this.tank};
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (facing == null) {
                return this.fluidInputCap.getAndCast();
            }
            PoweredMultiblockBlockEntity.MultiblockFace relativeFace = this.asRelativeFace(facing);
            if (FLUID_INPUT.equals(relativeFace)) {
                return this.fluidInputCap.getAndCast();
            }
            if (FLUID_OUTPUT.equals(relativeFace)) {
                return this.fluidOutputCap.getAndCast();
            }
        }
        if ((facing == null || new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public MixerRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MixerRecipe getRecipeForId(Level level, ResourceLocation id) {
        return MixerRecipe.RECIPES.getById(level, id);
    }

    @Override
    @Nullable
    protected MultiblockProcess<MixerRecipe> loadProcessFromNBT(CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_("recipe"));
        int[] inputSlots = tag.m_128465_("process_inputSlots");
        return new MultiblockProcessMixer(id, this::getRecipeForId, inputSlots);
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public MixerBlockEntity getGuiMaster() {
        return (MixerBlockEntity)this.master();
    }

    @Override
    public IEMenuTypes.BEContainer<MixerBlockEntity, ?> getContainerType() {
        return IEMenuTypes.MIXER;
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.shouldRenderAsActive();
    }

    public static class MultiblockProcessMixer
    extends MultiblockProcessInMachine<MixerRecipe> {
        public MultiblockProcessMixer(MixerRecipe recipe, BiFunction<Level, ResourceLocation, MixerRecipe> getRecipe, int ... inputSlots) {
            super(recipe, getRecipe, inputSlots);
        }

        public MultiblockProcessMixer(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, MixerRecipe> getRecipe, int ... inputSlots) {
            super(recipeId, getRecipe, inputSlots);
        }

        @Override
        protected List<FluidStack> getRecipeFluidOutputs(PoweredMultiblockBlockEntity<?, MixerRecipe> multiblock) {
            return Collections.emptyList();
        }

        @Override
        protected List<FluidTagInput> getRecipeFluidInputs(PoweredMultiblockBlockEntity<?, MixerRecipe> multiblock) {
            return Collections.emptyList();
        }

        @Override
        public boolean canProcess(PoweredMultiblockBlockEntity<?, MixerRecipe> multiblock) {
            MultiblockProcess.LevelDependentData levelData = this.getLevelData(multiblock.m_58904_());
            if (levelData.recipe() == null) {
                return true;
            }
            if (!(multiblock instanceof MixerBlockEntity)) {
                return false;
            }
            MixerBlockEntity mixer = (MixerBlockEntity)multiblock;
            return mixer.energyStorage.extractEnergy(levelData.energyPerTick(), true) == levelData.energyPerTick() && !mixer.tank.drain(((MixerRecipe)levelData.recipe()).fluidInput.withAmount(1), IFluidHandler.FluidAction.SIMULATE).isEmpty();
        }

        @Override
        public void doProcessTick(PoweredMultiblockBlockEntity<?, MixerRecipe> multiblock) {
            MultiblockProcess.LevelDependentData levelData = this.getLevelData(multiblock.m_58904_());
            if (levelData.recipe() == null) {
                this.clearProcess = true;
                return;
            }
            super.doProcessTick(multiblock);
            int timerStep = Math.max(levelData.maxTicks() / ((MixerRecipe)levelData.recipe()).fluidAmount, 1);
            for (int processPre = this.processTick; processPre < this.processTick; ++processPre) {
                double distBetweenExtra;
                if (processPre % timerStep != 0) continue;
                int amount = ((MixerRecipe)levelData.recipe()).fluidAmount / levelData.maxTicks();
                int leftover = ((MixerRecipe)levelData.recipe()).fluidAmount % levelData.maxTicks();
                if (leftover > 0 && Math.floor((double)this.processTick / (distBetweenExtra = (double)levelData.maxTicks() / (double)leftover)) != Math.floor((double)(this.processTick - 1) / distBetweenExtra)) {
                    ++amount;
                }
                MixerBlockEntity mixer = (MixerBlockEntity)multiblock;
                FluidStack drained = mixer.tank.drain(((MixerRecipe)levelData.recipe()).fluidInput.withAmount(amount), IFluidHandler.FluidAction.EXECUTE);
                if (drained.isEmpty()) continue;
                NonNullList components = NonNullList.m_122780_((int)this.inputSlots.length, (Object)ItemStack.f_41583_);
                for (int i = 0; i < components.size(); ++i) {
                    components.set(i, (Object)((ItemStack)mixer.getInventory().get(this.inputSlots[i])));
                }
                FluidStack output = ((MixerRecipe)levelData.recipe()).getFluidOutput(drained, (NonNullList<ItemStack>)components);
                FluidStack fs = Utils.copyFluidStackWithAmount(output, drained.getAmount(), false);
                mixer.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }
}

