/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.stone.FurnaceLikeBlockEntity;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlastFurnaceBlockEntity<T extends BlastFurnaceBlockEntity<T>>
extends FurnaceLikeBlockEntity<BlastFurnaceRecipe, T> {
    private final Supplier<BlastFurnaceRecipe> cachedRecipe = CachedRecipe.cached(BlastFurnaceRecipe::findRecipe, () -> this.f_58857_, () -> (ItemStack)this.inventory.get(0));

    public BlastFurnaceBlockEntity(IETemplateMultiblock mb, BlockEntityType<T> type, BlockPos pos, BlockState state) {
        super(mb, type, 1, ImmutableList.of(new FurnaceLikeBlockEntity.InputSlot<BlastFurnaceRecipe>(r -> r.input, 0)), ImmutableList.of(new FurnaceLikeBlockEntity.OutputSlot<BlastFurnaceRecipe>(r -> r.output, 2), new FurnaceLikeBlockEntity.OutputSlot<BlastFurnaceRecipe>(r -> r.slag, 3)), r -> r.time, pos, state);
    }

    @Override
    public IEMenuTypes.BEContainer<? super T, ?> getContainerType() {
        return IEMenuTypes.BLAST_FURNACE;
    }

    @Override
    @Nullable
    protected BlastFurnaceRecipe getRecipeForInput() {
        return this.cachedRecipe.get();
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return slot == 0 ? BlastFurnaceRecipe.findRecipe(this.f_58857_, stack, null) != null : slot == 1 && BlastFurnaceFuel.isValidBlastFuel(this.f_58857_, stack);
    }

    @Override
    protected int getBurnTimeOf(ItemStack fuel) {
        return BlastFurnaceFuel.getBlastFuelTime(this.f_58857_, fuel);
    }

    public static class CrudeBlastFurnaceBlockEntity
    extends BlastFurnaceBlockEntity<CrudeBlastFurnaceBlockEntity> {
        public CrudeBlastFurnaceBlockEntity(BlockEntityType<CrudeBlastFurnaceBlockEntity> type, BlockPos pos, BlockState state) {
            super(IEMultiblocks.BLAST_FURNACE, type, pos, state);
        }
    }
}

