/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public abstract class IEMinecartEntity<T extends BlockEntity>
extends AbstractMinecart
implements MenuProvider {
    protected T containedBlockEntity = (BlockEntity)this.getTileProvider().get();

    protected IEMinecartEntity(EntityType<?> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    protected IEMinecartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected abstract Supplier<T> getTileProvider();

    public T getContainedBlockEntity() {
        return this.containedBlockEntity;
    }

    public abstract void writeTileToItem(ItemStack var1);

    public abstract void readTileFromItem(LivingEntity var1, ItemStack var2);

    @Nonnull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        LazyOptional beCap;
        if (this.m_6084_() && this.containedBlockEntity != null && (beCap = this.containedBlockEntity.getCapability(capability, facing)).isPresent()) {
            return beCap;
        }
        return super.getCapability(capability, facing);
    }

    public void m_7617_(@Nonnull DamageSource source) {
        this.m_6074_();
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = this.m_142340_();
            this.writeTileToItem(itemstack);
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemstack);
        }
    }

    public int getComparatorLevel() {
        if (this.containedBlockEntity instanceof IEBlockInterfaces.IComparatorOverride) {
            return ((IEBlockInterfaces.IComparatorOverride)this.containedBlockEntity).getComparatorInputOverride();
        }
        return super.getComparatorLevel();
    }

    @Nonnull
    public InteractionResult m_6096_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult superResult = super.m_6096_(player, hand);
        if (superResult == InteractionResult.SUCCESS) {
            return superResult;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            T t = this.containedBlockEntity;
            if (t instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)t;
                if (menuProvider instanceof IEBlockInterfaces.IInteractionObjectIE) {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> buffer.writeInt(this.m_19879_()));
                } else {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return null;
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.containedBlockEntity != null) {
            CompoundTag bEntityData = this.containedBlockEntity.m_187482_();
            compound.m_128391_(bEntityData);
        }
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.containedBlockEntity = (BlockEntity)this.getTileProvider().get();
        this.containedBlockEntity.m_142466_(compound);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_213728_() {
        return Items.f_42449_;
    }

    public static interface MinecartConstructor {
        public IEMinecartEntity<?> make(Level var1, double var2, double var4, double var6);
    }
}

