/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public record GetterAndSetter<T>(Supplier<T> getter, Consumer<T> setter) implements Supplier<T>,
Consumer<T>
{
    public static <T> GetterAndSetter<T> standalone(T initial) {
        MutableObject box = new MutableObject(initial);
        return new GetterAndSetter<Object>(() -> ((Mutable)box).getValue(), arg_0 -> ((Mutable)box).setValue(arg_0));
    }

    public static <T> GetterAndSetter<T> getterOnly(Supplier<T> getter) {
        return new GetterAndSetter<Object>(getter, $ -> {});
    }

    public static <T> List<GetterAndSetter<T>> forArray(T[] data) {
        ArrayList<GetterAndSetter<T>> result = new ArrayList<GetterAndSetter<T>>(data.length);
        int i = 0;
        while (i < data.length) {
            int finalI = i++;
            result.add(new GetterAndSetter<Object>(() -> data[finalI], o -> {
                data[finalI] = o;
            }));
        }
        return result;
    }

    public void set(T newValue) {
        this.setter.accept(newValue);
    }

    @Override
    public T get() {
        return this.getter.get();
    }

    @Override
    public void accept(T t) {
        this.set(t);
    }
}

