/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class ChemthrowerItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem,
IEItemInterfaces.IScrollwheel {
    private static final int CAPACITY = 2000;

    public ChemthrowerItem() {
        super(new Item.Properties().m_41487_(1), "CHEMTHROWER");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int cap = this.getCapacity(stack, 2000);
        int numberOfTanks = this.getUpgrades(stack).m_128471_("multitank") ? 3 : 1;
        for (int i = 0; i < numberOfTanks; ++i) {
            Component add = IEItemFluidHandler.fluidItemInfoFlavor(ItemNBTHelper.getFluidStack(stack, "Fluid" + (Serializable)(i > 0 ? Integer.valueOf(i) : "")), cap);
            if (i > 0) {
                TextUtils.applyFormat(add, ChatFormatting.GRAY);
            }
            list.add(add);
        }
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!world.f_46443_) {
                ChemthrowerItem.setIgniteEnable(stack, !ChemthrowerItem.isIgniteEnable(stack));
            }
        } else {
            player.m_6672_(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.m_8105_(stack) - count;
            int consumed = (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
            if (consumed * duration <= fs.getAmount()) {
                float range;
                Vec3 v = player.m_20154_();
                int split = 8;
                boolean isGas = fs.getFluid().m_205067_(Tags.Fluids.GASEOUS);
                float scatter = isGas ? 0.25f : 0.15f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).m_128471_("focus")) {
                    range += 0.25f;
                    scatter = 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ChemthrowerItem.isIgniteEnable(stack);
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.m_82520_(player.m_217043_().m_188583_() * (double)scatter, player.m_217043_().m_188583_() * (double)scatter, player.m_217043_().m_188583_() * (double)scatter);
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(player.f_19853_, player, vecDir.f_82479_ * 0.25, vecDir.f_82480_ * 0.25, vecDir.f_82481_ * 0.25, fs);
                    chem.m_20256_(player.m_20184_().m_82549_(vecDir.m_82490_((double)range)));
                    if (!player.m_20096_()) {
                        player.m_20256_(player.m_20184_().m_82546_(vecDir.m_82490_(0.0025 * (double)range)));
                    }
                    if (ignite) {
                        chem.m_20254_(10);
                    }
                    if (player.f_19853_.f_46443_) continue;
                    player.f_19853_.m_7967_((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)IESounds.sprayFire.get(), SoundSource.PLAYERS, 0.5f, 1.5f);
                    } else {
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)IESounds.spray.get(), SoundSource.PLAYERS, 0.5f, 0.75f);
                    }
                }
            } else {
                player.m_21253_();
            }
        } else {
            player.m_21253_();
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.m_8105_(stack) - timeLeft;
            fs.shrink((Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() * duration);
            if (fs.getAmount() <= 0) {
                ItemNBTHelper.remove(stack, "Fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player playerEntity, boolean forward) {
        if (this.getUpgrades(stack).m_128471_("multitank")) {
            CompoundTag fluidTag = ItemNBTHelper.getTagCompound(stack, "Fluid");
            CompoundTag fluidTag1 = ItemNBTHelper.getTagCompound(stack, "Fluid1");
            CompoundTag fluidTag2 = ItemNBTHelper.getTagCompound(stack, "Fluid2");
            if (forward) {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag1);
            } else {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag1);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag);
            }
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty() && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.m_41728_((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack){
                LazyOptional<IEItemFluidHandler> fluids;
                LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.fluids = CapabilityUtils.constantOptional(new IEItemFluidHandler(stack, 2000));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "chemthrower"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == ForgeCapabilities.FLUID_HANDLER_ITEM) {
                        return this.fluids.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public int getSlotCount() {
        return 4;
    }

    @Override
    public int getCapacity(ItemStack stack, int baseCapacity) {
        return baseCapacity + this.getUpgrades(stack).m_128451_("capacity");
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, "CHEMTHROWER", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, "CHEMTHROWER", stack, true, level, getPlayer)};
    }

    public static void setIgniteEnable(ItemStack chemthrower, boolean enabled) {
        chemthrower.m_41784_().m_128379_("ignite", enabled);
    }

    public static boolean isIgniteEnable(ItemStack chemthrower) {
        return ItemNBTHelper.getBoolean(chemthrower, "ignite");
    }
}

