/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.client.DynamicModelLoader;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;

public class DrillheadItem
extends IEBaseItem
implements IDrillHead {
    public static final DrillHeadPerm STEEL = new DrillHeadPerm("steel", IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 3, 1, (Tier)Tiers.DIAMOND, 10.0f, 7, 10000, new ResourceLocation("immersiveengineering", "item/drill_diesel"));
    public static final DrillHeadPerm IRON = new DrillHeadPerm("iron", (TagKey<Item>)Tags.Items.INGOTS_IRON, 2, 1, (Tier)Tiers.IRON, 9.0f, 6, 6000, new ResourceLocation("immersiveengineering", "item/drill_iron"));
    public static final String DAMAGE_KEY_OLD = "headDamage";
    public static final String DAMAGE_KEY = "Damage";
    public DrillHeadPerm perms;

    public DrillheadItem(DrillHeadPerm perms) {
        super(new Item.Properties().m_41487_(1));
        this.perms = perms;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.size", (Object[])new Object[]{this.perms.drillSize, this.perms.drillDepth}));
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.level", (Object[])new Object[]{Utils.getHarvestLevelName(this.getMiningLevel(stack))}));
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.speed", (Object[])new Object[]{Utils.formatDouble(this.getMiningSpeed(stack), "0.###")}));
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.drillhead.damage", (Object[])new Object[]{Utils.formatDouble(this.getAttackDamage(stack), "0.###")}));
        int maxDmg = this.getMaximumHeadDamage(stack);
        int dmg = maxDmg - this.getHeadDamage(stack);
        float quote = (float)dmg / (float)maxDmg;
        String status = "" + ((double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN)));
        String s = status + (this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack)) + "/" + this.getMaximumHeadDamage(stack);
        list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.info.durability", (Object[])new Object[]{s}));
    }

    public boolean m_6832_(ItemStack stack, ItemStack material) {
        return material.m_204117_(this.perms.repairMaterial);
    }

    @Override
    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, Player player) {
        return false;
    }

    @Override
    public void afterBlockbreak(ItemStack drill, ItemStack head, Player player) {
    }

    @Override
    public Tier getMiningLevel(ItemStack head) {
        return this.perms.drillLevel;
    }

    @Override
    public float getMiningSpeed(ItemStack head) {
        return this.perms.drillSpeed;
    }

    @Override
    public float getAttackDamage(ItemStack head) {
        return this.perms.drillAttack;
    }

    @Override
    public int getHeadDamage(ItemStack head) {
        if (head.m_41782_()) {
            CompoundTag nbt = head.m_41784_();
            if (nbt.m_128425_(DAMAGE_KEY_OLD, 3)) {
                return nbt.m_128451_(DAMAGE_KEY_OLD);
            }
            return nbt.m_128451_(DAMAGE_KEY);
        }
        return 0;
    }

    @Override
    public int getMaximumHeadDamage(ItemStack head) {
        return this.perms.maxDamage;
    }

    @Override
    public void damageHead(ItemStack head, int dmg) {
        DrillheadItem.setHeadDamage(head, this.getHeadDamage(head) + dmg);
    }

    public static void setHeadDamage(ItemStack head, int totalDamage) {
        CompoundTag nbt = head.m_41784_();
        nbt.m_128473_(DAMAGE_KEY_OLD);
        nbt.m_128405_(DAMAGE_KEY, totalDamage);
    }

    @Override
    public ResourceLocation getDrillTexture(ItemStack drill, ItemStack head) {
        return this.perms.texture;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getHeadDamage(stack) / (float)this.getMaximumHeadDamage(stack)));
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    @Override
    public ImmutableList<BlockPos> getExtraBlocksDug(ItemStack head, Level world, Player player, HitResult rtr) {
        if (!(rtr instanceof BlockHitResult)) {
            return ImmutableList.of();
        }
        BlockHitResult brtr = (BlockHitResult)rtr;
        Direction side = brtr.m_82434_();
        int diameter = this.perms.drillSize;
        int depth = this.perms.drillDepth;
        BlockPos startPos = brtr.m_82425_();
        BlockState state = world.m_8055_(startPos);
        float maxHardness = 1.0f;
        if (!state.m_60795_()) {
            maxHardness = state.m_60625_(player, (BlockGetter)world, startPos) * 0.4f;
        }
        if (maxHardness < 0.0f) {
            maxHardness = 0.0f;
        }
        if (diameter % 2 == 0) {
            float hx = (float)brtr.m_82450_().f_82479_ - (float)brtr.m_82425_().m_123341_();
            float hy = (float)brtr.m_82450_().f_82480_ - (float)brtr.m_82425_().m_123342_();
            float hz = (float)brtr.m_82450_().f_82481_ - (float)brtr.m_82425_().m_123343_();
            if (side.m_122434_() == Direction.Axis.Y && (double)hx < 0.5 || side.m_122434_() == Direction.Axis.Z && (double)hx < 0.5) {
                startPos = startPos.m_7918_(-diameter / 2, 0, 0);
            }
            if (side.m_122434_() != Direction.Axis.Y && (double)hy < 0.5) {
                startPos = startPos.m_7918_(0, -diameter / 2, 0);
            }
            if (side.m_122434_() == Direction.Axis.Y && (double)hz < 0.5 || side.m_122434_() == Direction.Axis.X && (double)hz < 0.5) {
                startPos = startPos.m_7918_(0, 0, -diameter / 2);
            }
        } else {
            startPos = startPos.m_7918_(-(side.m_122434_() == Direction.Axis.X ? 0 : diameter / 2), -(side.m_122434_() == Direction.Axis.Y ? 0 : diameter / 2), -(side.m_122434_() == Direction.Axis.Z ? 0 : diameter / 2));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    boolean hardness;
                    BlockPos pos = startPos.m_7918_(side.m_122434_() == Direction.Axis.X ? dd : dw, side.m_122434_() == Direction.Axis.Y ? dd : dh, side.m_122434_() == Direction.Axis.Y ? dh : (side.m_122434_() == Direction.Axis.X ? dw : dd));
                    if (pos.equals((Object)brtr.m_82425_()) || (state = world.m_8055_(pos)).m_60795_()) continue;
                    Block block = state.m_60734_();
                    float h = state.m_60625_(player, (BlockGetter)world, pos);
                    boolean canHarvest = block.canHarvestBlock(world.m_8055_(pos), (BlockGetter)world, pos, player);
                    boolean drillMat = IEItems.Tools.DRILL.get().isEffective(ItemStack.f_41583_, state);
                    boolean bl = hardness = h >= maxHardness;
                    if (!canHarvest || !drillMat || !hardness) continue;
                    b.add((Object)pos);
                }
            }
        }
        return b.build();
    }

    public static class DrillHeadPerm {
        final String name;
        final TagKey<Item> repairMaterial;
        final int drillSize;
        final int drillDepth;
        final Tier drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        public final ResourceLocation texture;

        public DrillHeadPerm(String name, TagKey<Item> repairMaterial, int drillSize, int drillDepth, Tier drillLevel, float drillSpeed, int drillAttack, int maxDamage, ResourceLocation texture) {
            this.name = name;
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
            DynamicModelLoader.requestTexture(texture);
        }
    }
}

