/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageRedstoneLevel;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record MessageRequestRedstoneUpdate(BlockPos pos) implements IMessage
{
    public MessageRequestRedstoneUpdate(FriendlyByteBuf buf) {
        this(MessageRequestRedstoneUpdate.readPos(buf));
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        MessageRequestRedstoneUpdate.writePos(buf, this.pos);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerLevel level = Objects.requireNonNull(ctx.getSender()).m_9236_();
            BlockState blockState = level.m_8055_(this.pos);
            VoltmeterItem.RemoteRedstoneData data = new VoltmeterItem.RemoteRedstoneData(this.pos, level.m_46467_(), blockState.m_60803_(), MessageRequestRedstoneUpdate.redstoneLevel((Level)level, this.pos));
            ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)ctx).getSender()), (Object)new MessageRedstoneLevel(data));
        });
    }

    public static byte redstoneLevel(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        byte redstoneLevel = 0;
        if (blockState != null) {
            if (blockState.m_60803_()) {
                redstoneLevel = blockState.m_61145_((Property)RedStoneWireBlock.f_55500_).orElse(0).byteValue();
                for (Direction facing : Direction.values()) {
                    redstoneLevel = (byte)Math.max(redstoneLevel, blockState.m_60746_((BlockGetter)level, pos, facing));
                }
            } else {
                redstoneLevel = (byte)Math.max(redstoneLevel, level.m_46751_(pos));
            }
        }
        return redstoneLevel;
    }

    public static BlockPos readPos(FriendlyByteBuf buf) {
        return buf.m_130135_();
    }

    public static void writePos(FriendlyByteBuf out, BlockPos pos) {
        out.m_130064_(pos);
    }
}

