/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.MissingMappingsEvent;

public class MissingMappingsHelper {
    private static final Map<ResourceKey<?>, Supplier<?>> REMAPPERS = new HashMap();

    public static void handleRemapping(MissingMappingsEvent event) {
        MissingMappingsHelper.handleRemapping(event, Registry.f_122904_);
        MissingMappingsHelper.handleRemapping(event, Registry.f_122901_);
        MissingMappingsHelper.handleRemapping(event, Registry.f_122899_);
    }

    private static <T> void handleRemapping(MissingMappingsEvent event, ResourceKey<Registry<T>> key) {
        List mappings = event.getMappings(key, "immersiveengineering");
        mappings.forEach(mapping -> {
            Supplier<?> supplier = REMAPPERS.get(ResourceKey.m_135785_((ResourceKey)key, (ResourceLocation)mapping.getKey()));
            if (supplier != null) {
                mapping.remap(supplier.get());
            }
        });
    }

    public static <T> void addRemapping(Registry<T> registry, ResourceLocation oldKey, Supplier<T> newSupplier) {
        REMAPPERS.put(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)oldKey), newSupplier);
    }
}

