/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ClickableList
extends Button {
    private String[] headers;
    private boolean[] isCategory;
    @Nonnull
    private List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
    private float textScale;
    private final Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler;
    private int offset;
    private int maxOffset;
    private final int perPage;
    private ManualScreen gui;

    ClickableList(ManualScreen gui, int x, int y, int w, int h, float textScale, @Nonnull List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes, Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> handler) {
        super(x, y, w, h, (Component)Component.m_237119_(), btn -> {});
        this.gui = gui;
        this.textScale = textScale;
        this.handler = handler;
        this.perPage = (h - 8) / this.getFontHeight();
        this.setEntries(nodes);
    }

    int getFontHeight() {
        Objects.requireNonNull(this.gui.manual.fontRenderer());
        return (int)(9.0f * this.textScale);
    }

    public void m_6305_(PoseStack transform, int mx, int my, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        Font fr = this.gui.manual.fontRenderer();
        int mmY = my - this.f_93621_;
        transform.m_85836_();
        transform.m_85841_(this.textScale, this.textScale, this.textScale);
        transform.m_85837_((double)((float)this.f_93620_ / this.textScale), (double)((float)this.f_93621_ / this.textScale), 0.0);
        this.f_93622_ = mx >= this.f_93620_ && mx < this.f_93620_ + this.f_93618_ && my >= this.f_93621_ && my < this.f_93621_ + this.f_93619_;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            int j;
            boolean currEntryHovered;
            int col = this.gui.manual.getTextColour();
            boolean bl = currEntryHovered = this.f_93622_ && mmY >= i * this.getFontHeight() && mmY < (i + 1) * this.getFontHeight();
            if (currEntryHovered) {
                col = this.gui.manual.getHighlightColour();
            }
            if (i != 0) {
                transform.m_85837_(0.0, (double)this.getFontHeight(), 0.0);
            }
            if ((j = this.offset + i) > this.headers.length - 1) {
                j = this.headers.length - 1;
            }
            String s = this.headers[j];
            if (this.isCategory[j]) {
                ManualUtils.bindTexture(this.gui.texture);
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                this.m_93228_(transform, 0, 0, 11, 226 + (currEntryHovered ? 20 : 0), 5, 10);
            }
            fr.m_92883_(transform, s, this.isCategory[j] ? 7.0f : 0.0f, 0.0f, col);
        }
        transform.m_85841_(1.0f / this.textScale, 1.0f / this.textScale, 1.0f / this.textScale);
        transform.m_85849_();
        if (this.maxOffset > 0) {
            int minVisibleBlack = 0x1B000000;
            int mainBarBlack = 0x28000000;
            float totalHeight = this.maxOffset * this.getFontHeight() + this.f_93619_;
            float heightTopRel = (float)(this.offset * this.getFontHeight()) / totalHeight;
            float heightBottomRel = (float)(this.offset * this.getFontHeight() + this.f_93619_) / totalHeight;
            int heightTopAbs = (int)(heightTopRel * (float)this.f_93619_);
            int heightBottomAbs = (int)(heightBottomRel * (float)this.f_93619_);
            ClickableList.m_93172_((PoseStack)transform, (int)(this.f_93620_ + this.f_93618_), (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_ + 8), (int)(this.f_93621_ + this.f_93619_), (int)0x1B000000);
            ClickableList.m_93172_((PoseStack)transform, (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + heightTopAbs), (int)(this.f_93620_ + this.f_93618_ + 7), (int)(this.f_93621_ + heightBottomAbs), (int)0x28000000);
        }
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double amount) {
        if (amount < 0.0 && this.offset < this.maxOffset) {
            ++this.offset;
            return true;
        }
        if (amount > 0.0 && this.offset > 0) {
            --this.offset;
            return true;
        }
        return false;
    }

    @Nullable
    public Tree.AbstractNode<ResourceLocation, ManualEntry> getSelected(double mx, double my) {
        if (!super.m_93680_(mx, my)) {
            return null;
        }
        double mmY = my - (double)this.f_93621_;
        for (int i = 0; i < Math.min(this.perPage, this.headers.length); ++i) {
            if (!(mmY >= (double)(i * this.getFontHeight())) || !(mmY < (double)((i + 1) * this.getFontHeight()))) continue;
            return this.nodes.get(this.offset + i);
        }
        return null;
    }

    public void m_5716_(double mx, double my) {
        this.handler.accept(this.getSelected(mx, my));
    }

    protected boolean m_93680_(double mx, double my) {
        return this.getSelected(mx, my) != null;
    }

    public void setEntries(List<Tree.AbstractNode<ResourceLocation, ManualEntry>> nodes) {
        this.nodes = nodes;
        this.headers = new String[nodes.size()];
        this.isCategory = new boolean[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.headers[i] = ManualUtils.getTitleForNode(nodes.get(i), this.gui.manual);
            this.isCategory[i] = !nodes.get(i).isLeaf();
        }
        this.maxOffset = this.perPage < this.headers.length ? this.headers.length - this.perPage : 0;
        this.f_93619_ = this.getFontHeight() * Math.min(this.perPage, this.headers.length);
    }

    public int m_93694_() {
        return this.f_93619_;
    }
}

