/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMultipartTicking;
import org.cyclops.integrateddynamics.network.packet.PartOffsetsDataPacket;

public class PartOffsetsClientNotifier {
    private static final PartOffsetsClientNotifier _INSTANCE = new PartOffsetsClientNotifier();
    private final List<UUID> players = Lists.newArrayList();

    private PartOffsetsClientNotifier() {
    }

    public static PartOffsetsClientNotifier getInstance() {
        return _INSTANCE;
    }

    protected ServerPlayer getPlayer(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
    }

    public synchronized void registerPlayer(ServerPlayer player) {
        if (!this.players.contains(player.m_20148_())) {
            this.players.add(player.m_20148_());
            this.sendPartOffsetsToPlayer(player);
        }
    }

    public synchronized void unRegisterPlayer(ServerPlayer player) {
        this.players.remove(player.m_20148_());
    }

    public void sendPartOffsetsToPlayer(ServerPlayer player) {
        BlockPos centerPos = player.m_20097_();
        List offsets = (List)WorldHelpers.foldArea((LevelAccessor)player.m_20193_(), (int)GeneralConfig.partOffsetRenderDistance, (BlockPos)centerPos, (list, world, pos) -> {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityMultipartTicking.class).ifPresent(blockEntity -> {
                for (Map.Entry<Direction, IPartType<?, ?>> entry : blockEntity.getPartContainer().getParts().entrySet()) {
                    Direction sourceSide = entry.getKey();
                    IPartType<?, ?> partType = entry.getValue();
                    IPartState partState = blockEntity.getPartContainer().getPartState(entry.getKey());
                    Vec3i targetOffset = partType.getTargetOffset(partState);
                    Optional<Direction> targetSideOptional = Optional.ofNullable(partType.getTargetSideOverride(partState));
                    if (targetOffset.equals((Object)Vec3i.f_123288_) && !targetSideOptional.isPresent()) continue;
                    Direction targetSide = targetSideOptional.orElse(sourceSide.m_122424_());
                    targetOffset = targetOffset.m_7918_(-sourceSide.m_122424_().m_122429_(), -sourceSide.m_122424_().m_122430_(), -sourceSide.m_122424_().m_122431_());
                    list.add(new Entry(pos, sourceSide, targetOffset, targetSide));
                }
            });
            return list;
        }, (Object)Lists.newArrayList());
        IntegratedDynamics._instance.getPacketHandler().sendToPlayer((PacketBase)new PartOffsetsDataPacket(offsets), player);
    }

    public void tick() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (UUID playerId : this.players) {
            ServerPlayer player = server.m_6846_().m_11259_(playerId);
            if (player == null) continue;
            this.sendPartOffsetsToPlayer(player);
        }
    }

    public record Entry(BlockPos source, Direction sourceSide, Vec3i targetOffset, Direction targetSide) {
    }
}

