/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.location;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocationRegistry;

public class TerminalStorageLocationRegistry
implements ITerminalStorageLocationRegistry {
    private static TerminalStorageLocationRegistry INSTANCE = new TerminalStorageLocationRegistry();
    private final Map<String, ITerminalStorageLocation<?>> locations = Maps.newLinkedHashMap();

    public static TerminalStorageLocationRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <L, T extends ITerminalStorageLocation<L>> T register(T location) {
        this.locations.put(location.getName().toString(), location);
        return location;
    }

    @Override
    @Nullable
    public ITerminalStorageLocation<?> getLocation(ResourceLocation name) {
        return this.locations.get(name.toString());
    }

    @Override
    public Collection<ITerminalStorageLocation<?>> getLocations() {
        return this.locations.values();
    }
}

