/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.codec;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.moddingx.libx.codec.CodecOps;

public class CodecHelper {
    public static final CodecOps<JsonElement> JSON = new CodecOps<JsonElement>(JsonElement.class, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
    public static final CodecOps<Tag> NBT = new CodecOps<Tag>(Tag.class, (DynamicOps<Tag>)NbtOps.f_128958_);

    public static <T> DataResult<T> nonNull(@Nullable T value, String error) {
        return value == null ? DataResult.error((String)error) : DataResult.success(value);
    }

    public static <T> DataResult<T> doesNotThrow(Callable<T> value) {
        try {
            return DataResult.success(value.call());
        }
        catch (Exception e) {
            return DataResult.error((String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    @SafeVarargs
    public static <T> DataResult<T> or(Supplier<DataResult<T>> ... results) {
        Supplier[] resultsEvaluated = new Supplier[results.length];
        for (int i = 0; i < results.length; ++i) {
            DataResult result = results[i].get();
            resultsEvaluated[i] = () -> result;
            if (!result.result().isPresent()) continue;
            return result;
        }
        return CodecHelper.orPartial(resultsEvaluated);
    }

    @SafeVarargs
    public static <T> DataResult<T> orPartial(Supplier<DataResult<T>> ... results) {
        DataResult<T> current = DataResult.error((String)"Empty OR-chain.");
        for (Supplier<DataResult<DataResult<T>>> supplier : results) {
            current = supplier.get();
            if (!current.resultOrPartial(err -> {}).isPresent()) continue;
            return current;
        }
        return current;
    }
}

