/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider;

import com.mojang.serialization.Lifecycle;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import org.moddingx.libx.mod.ModX;

public abstract class TagProviderBase<T>
extends TagsProvider<T> {
    protected final ModX mod;
    @Nullable
    protected final IForgeRegistry<T> forgeRegistry;

    protected TagProviderBase(ModX mod, DataGenerator generator, @Nonnull Registry<T> registry, @Nullable ExistingFileHelper fileHelper) {
        super(generator, registry, mod.modid, fileHelper);
        this.mod = mod;
        this.forgeRegistry = null;
    }

    protected TagProviderBase(ModX mod, DataGenerator generator, @Nonnull IForgeRegistry<T> registry, @Nullable ExistingFileHelper fileHelper) {
        super(generator, TagProviderBase.wrapForge(registry), mod.modid, fileHelper);
        this.mod = mod;
        this.forgeRegistry = registry;
    }

    protected final void m_6577_() {
        this.setup();
        if (this.forgeRegistry != null) {
            this.forgeRegistry.getEntries().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::m_135782_))).map(Map.Entry::getValue).forEach(this::defaultTags);
        } else {
            this.f_126540_.m_6579_().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).m_135782_().m_135827_())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::m_135782_))).map(Map.Entry::getValue).forEach(this::defaultTags);
        }
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " " + (this.forgeRegistry == null ? this.f_126540_.m_123023_().m_135782_() : this.forgeRegistry.getRegistryName()) + " tags";
    }

    protected abstract void setup();

    public void defaultTags(T element) {
    }

    private static <T> Registry<T> wrapForge(IForgeRegistry<T> forgeRegistry) {
        if (forgeRegistry.tags() == null) {
            throw new IllegalArgumentException("Registry has no tag support: " + forgeRegistry.getRegistryName());
        }
        if (forgeRegistry.getDefaultKey() == null) {
            return GameData.getWrapper((ResourceKey)forgeRegistry.getRegistryKey(), (Lifecycle)Lifecycle.experimental());
        }
        return GameData.getWrapper((ResourceKey)forgeRegistry.getRegistryKey(), (Lifecycle)Lifecycle.experimental(), (String)"default");
    }
}

