/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.forgespi.locating.IModFile;

public class DatapackHelper {
    public static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        return builder.create();
    });

    public static Supplier<InputStream> generatePackMeta(IModFile file, String description, PackType packType) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bout, StandardCharsets.UTF_8);
            JsonObject packFile = new JsonObject();
            JsonObject packSection = new JsonObject();
            packSection.addProperty("description", description);
            packSection.addProperty("pack_format", (Number)DatapackHelper.getPackFormat(file, packType));
            packFile.add("pack", (JsonElement)packSection);
            writer.write(GSON.toJson((JsonElement)packFile) + "\n");
            ((Writer)writer).close();
            bout.close();
            byte[] data = bout.toByteArray();
            return () -> new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create dynamic pack.mcmeta", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getPackFormat(IModFile mod, PackType packType) {
        try {
            Path path = mod.findResource(new String[]{"pack.mcmeta"});
            if (!Files.exists(path, new LinkOption[0])) {
                return 10;
            }
            try (BufferedReader in = Files.newBufferedReader(path);){
                JsonObject packInfo = ((JsonObject)GSON.fromJson((Reader)in, JsonObject.class)).get("pack").getAsJsonObject();
                String specificKey = "forge:" + packType.f_143750_.name().toLowerCase(Locale.ROOT) + "_pack_format";
                if (packInfo.has(specificKey)) {
                    int n2 = packInfo.get(specificKey).getAsInt();
                    return n2;
                }
                int n = packInfo.get("pack_format").getAsInt();
                return n;
            }
        }
        catch (Exception e) {
            return 10;
        }
    }
}

