/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import mekanism.api.providers.IItemProvider;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.lib.Version;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.config.ToolsConfig;
import mekanism.tools.common.material.BaseMekanismMaterial;
import mekanism.tools.common.registries.ToolsItems;
import mekanism.tools.common.registries.ToolsRecipeSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismtools")
public class MekanismTools
implements IModModule {
    public static final String MODID = "mekanismtools";
    public static MekanismTools instance;
    public final Version versionNumber;

    public MekanismTools() {
        instance = this;
        Mekanism.addModule((IModModule)instance);
        MekanismToolsConfig.registerConfigs(ModLoadingContext.get());
        MinecraftForge.EVENT_BUS.addListener(this::onLivingSpecialSpawn);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        ToolsItems.ITEMS.register(modEventBus);
        ToolsRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            MekanismModConfig mekConfig = (MekanismModConfig)config;
            mekConfig.clearCache();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ToolsTags.init());
        this.registerTiers(MekanismToolsConfig.tools.bronze, MekanismToolsConfig.tools.lapisLazuli, MekanismToolsConfig.tools.osmium, MekanismToolsConfig.tools.steel, MekanismToolsConfig.tools.refinedGlowstone, MekanismToolsConfig.tools.refinedObsidian);
        Mekanism.logger.info("Loaded 'Mekanism: Tools' module.");
    }

    private void registerTiers(BaseMekanismMaterial ... tiers) {
        HashMultimap vanillaTiers = HashMultimap.create();
        for (Tiers tiers2 : Tiers.values()) {
            vanillaTiers.put((Object)tiers2.m_6604_(), (Object)tiers2);
        }
        for (BaseMekanismMaterial baseMekanismMaterial : tiers) {
            int level = baseMekanismMaterial.m_6604_();
            Collection equivalent = vanillaTiers.get((Object)level);
            Collection vanillaNext = vanillaTiers.get((Object)(level + 1));
            TierSortingRegistry.registerTier((Tier)baseMekanismMaterial, (ResourceLocation)MekanismTools.rl(baseMekanismMaterial.getRegistryPrefix()), new ArrayList(equivalent), new ArrayList(vanillaNext));
        }
    }

    private void setStackIfEmpty(LivingEntity entity, EquipmentSlot slot, ItemStack item) {
        if (entity.m_6844_(slot).m_41619_()) {
            entity.m_8061_(slot, item);
        }
    }

    private void setEntityArmorWithChance(RandomSource random, LivingEntity entity, IItemProvider sword, IItemProvider helmet, IItemProvider chestplate, IItemProvider leggings, IItemProvider boots, ToolsConfig.ArmorSpawnChanceConfig chanceConfig) {
        if (entity instanceof Zombie && random.m_188500_() < chanceConfig.swordChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlot.MAINHAND, sword.getItemStack());
        }
        if (random.m_188500_() < chanceConfig.helmetChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlot.HEAD, helmet.getItemStack());
        }
        if (random.m_188500_() < chanceConfig.chestplateChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlot.CHEST, chestplate.getItemStack());
        }
        if (random.m_188500_() < chanceConfig.leggingsChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlot.LEGS, leggings.getItemStack());
        }
        if (random.m_188500_() < chanceConfig.bootsChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlot.FEET, boots.getItemStack());
        }
    }

    private void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        RandomSource random;
        double chance;
        Mob entity = event.getEntity();
        if ((entity instanceof Zombie || entity instanceof Skeleton || entity instanceof Piglin) && (chance = (random = event.getLevel().m_213780_()).m_188500_()) < MekanismToolsConfig.tools.armorSpawnRate.get()) {
            switch (entity instanceof Piglin ? 0 : random.m_188503_(6)) {
                case 0: {
                    this.setEntityArmorWithChance(random, (LivingEntity)entity, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_SWORD, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_HELMET, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_LEGGINGS, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_BOOTS, MekanismToolsConfig.tools.refinedGlowstoneSpawnRate);
                    break;
                }
                case 1: {
                    this.setEntityArmorWithChance(random, (LivingEntity)entity, (IItemProvider)ToolsItems.LAPIS_LAZULI_SWORD, (IItemProvider)ToolsItems.LAPIS_LAZULI_HELMET, (IItemProvider)ToolsItems.LAPIS_LAZULI_CHESTPLATE, (IItemProvider)ToolsItems.LAPIS_LAZULI_LEGGINGS, (IItemProvider)ToolsItems.LAPIS_LAZULI_BOOTS, MekanismToolsConfig.tools.lapisLazuliSpawnRate);
                    break;
                }
                case 2: {
                    this.setEntityArmorWithChance(random, (LivingEntity)entity, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_SWORD, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_HELMET, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_LEGGINGS, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_BOOTS, MekanismToolsConfig.tools.refinedObsidianSpawnRate);
                    break;
                }
                case 3: {
                    this.setEntityArmorWithChance(random, (LivingEntity)entity, (IItemProvider)ToolsItems.STEEL_SWORD, (IItemProvider)ToolsItems.STEEL_HELMET, (IItemProvider)ToolsItems.STEEL_CHESTPLATE, (IItemProvider)ToolsItems.STEEL_LEGGINGS, (IItemProvider)ToolsItems.STEEL_BOOTS, MekanismToolsConfig.tools.steelSpawnRate);
                    break;
                }
                case 4: {
                    this.setEntityArmorWithChance(random, (LivingEntity)entity, (IItemProvider)ToolsItems.BRONZE_SWORD, (IItemProvider)ToolsItems.BRONZE_HELMET, (IItemProvider)ToolsItems.BRONZE_CHESTPLATE, (IItemProvider)ToolsItems.BRONZE_LEGGINGS, (IItemProvider)ToolsItems.BRONZE_BOOTS, MekanismToolsConfig.tools.bronzeSpawnRate);
                    break;
                }
                case 5: {
                    this.setEntityArmorWithChance(random, (LivingEntity)entity, (IItemProvider)ToolsItems.OSMIUM_SWORD, (IItemProvider)ToolsItems.OSMIUM_HELMET, (IItemProvider)ToolsItems.OSMIUM_CHESTPLATE, (IItemProvider)ToolsItems.OSMIUM_LEGGINGS, (IItemProvider)ToolsItems.OSMIUM_BOOTS, MekanismToolsConfig.tools.osmiumSpawnRate);
                }
            }
        }
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Tools";
    }

    public void resetClient() {
    }
}

