/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mythicbotany.MythicBotany;
import mythicbotany.infuser.InfuserRecipe;
import mythicbotany.register.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerrestrialAgglomerationDrawable;
import vazkii.botania.common.block.BotaniaBlocks;

public class InfusionCategory
implements IRecipeCategory<InfuserRecipe> {
    public static final RecipeType<InfuserRecipe> TYPE = RecipeType.create((String)MythicBotany.getInstance().modid, (String)"infuser", InfuserRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable infuserPlate;

    public InfusionCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 141);
        this.localizedName = Component.m_237115_((String)"block.mythicbotany.mana_infuser");
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/terrasteel_jei_overlay.png"), 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.manaInfuser));
        IDrawable shimmerrock = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BotaniaBlocks.shimmerrock));
        this.infuserPlate = new TerrestrialAgglomerationDrawable(shimmerrock, shimmerrock, guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50074_)));
    }

    @Nonnull
    public RecipeType<InfuserRecipe> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull InfuserRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 37).addItemStack(recipe.m_8043_());
        double angle = 360.0 / (double)recipe.m_7527_().size();
        Vec2 point = new Vec2(49.0f, 6.0f);
        Vec2 center = new Vec2(49.0f, 38.0f);
        for (int i = 1; i <= recipe.m_7527_().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, Math.round(point.f_82470_), Math.round(point.f_82471_)).addIngredients((Ingredient)recipe.m_7527_().get(i - 1));
            point = PetalApothecaryRecipeCategory.rotatePointAbout((Vec2)point, (Vec2)center, (double)angle);
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 49, 93).addItemStack(new ItemStack(ModBlocks.manaInfuser));
    }

    public void draw(@Nonnull InfuserRecipe recipe, @Nonnull IRecipeSlotsView slots, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(poseStack, 25, 14);
        HUDHandler.renderManaBar((PoseStack)poseStack, (int)6, (int)126, (int)255, (float)0.75f, (int)recipe.getManaUsage(), (int)4000000);
        this.infuserPlate.draw(poseStack, 35, 92);
        RenderSystem.m_69461_();
        MutableComponent manaAmount = Component.m_237113_((String)BigDecimal.valueOf((double)recipe.getManaUsage() / 1000000.0).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString()).m_130940_(ChatFormatting.BLUE);
        MutableComponent tc = Component.m_237110_((String)"tooltip.mythicbotany.cost_pools", (Object[])new Object[]{manaAmount});
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)tc, (float)(57 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)tc) / 2), 133.0f, 0);
    }
}

